/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.profile.config;

import java.time.Duration;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.config.OverriddenIssuerProfileConfiguration;
import net.shibboleth.oidc.metadata.policy.MetadataPolicy;
import net.shibboleth.oidc.profile.oauth2.config.AbstractOAuth2FlowAwareProfileConfiguration;
import net.shibboleth.utilities.java.support.annotation.constraint.NonNegative;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import org.opensaml.profile.context.ProfileRequestContext;

public class OIDCDynamicRegistrationConfiguration
extends AbstractOAuth2FlowAwareProfileConfiguration
implements OverriddenIssuerProfileConfiguration {
    public static final String PROTOCOL_URI = "https://openid.net/specs/openid-connect-registration-1_0.html";
    public static final String PROFILE_ID = "http://shibboleth.net/ns/profiles/oidc/registration";
    @Nonnull
    private Function<ProfileRequestContext, String> issuerLookupStrategy = FunctionSupport.constant(null);
    @Nonnull
    private Function<ProfileRequestContext, Duration> registrationValidityPeriodLookupStrategy;
    @Nullable
    private Function<ProfileRequestContext, Duration> secretExpirationPeriodLookupStrategy;
    @Nullable
    private Function<ProfileRequestContext, Map<String, MetadataPolicy>> metadataPolicyLookupStrategy;

    public OIDCDynamicRegistrationConfiguration() {
        this(PROFILE_ID);
    }

    public OIDCDynamicRegistrationConfiguration(@Nonnull @NotEmpty String profileId) {
        super(profileId);
        this.setRegistrationValidityPeriod(Duration.ofHours(24L));
        this.setSecretExpirationPeriod(Duration.ofDays(365L));
        this.metadataPolicyLookupStrategy = FunctionSupport.constant(null);
    }

    @Nullable
    @NotEmpty
    public String getIssuer(@Nullable ProfileRequestContext profileRequestContext) {
        return this.issuerLookupStrategy.apply(profileRequestContext);
    }

    public void setIssuer(@Nullable @NotEmpty String issuer) {
        this.issuerLookupStrategy = FunctionSupport.constant((Object)issuer);
    }

    public void setIssuerLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.issuerLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Issuer lookup strategy cannot be null");
    }

    @Nullable
    @NonNegative
    public Duration getRegistrationValidityPeriod(@Nullable ProfileRequestContext profileRequestContext) {
        Duration period = this.registrationValidityPeriodLookupStrategy.apply(profileRequestContext);
        Constraint.isFalse((period != null && period.isNegative() ? 1 : 0) != 0, (String)"Validity period cannot be negative");
        return period;
    }

    public void setRegistrationValidityPeriod(@Nullable @NonNegative Duration period) {
        Constraint.isFalse((period != null && period.isNegative() ? 1 : 0) != 0, (String)"Validity period cannot be negative");
        this.registrationValidityPeriodLookupStrategy = FunctionSupport.constant((Object)period);
    }

    public void setRegistrationValidityPeriodLookupStrategy(@Nonnull Function<ProfileRequestContext, Duration> strategy) {
        this.registrationValidityPeriodLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nullable
    @NonNegative
    public Duration getSecretExpirationPeriod(@Nullable ProfileRequestContext profileRequestContext) {
        Duration period = this.secretExpirationPeriodLookupStrategy.apply(profileRequestContext);
        Constraint.isFalse((period != null && period.isNegative() ? 1 : 0) != 0, (String)"Validity period cannot be negative");
        return period;
    }

    public void setSecretExpirationPeriod(@Nullable @NonNegative Duration period) {
        Constraint.isFalse((period != null && period.isNegative() ? 1 : 0) != 0, (String)"Validity period cannot be negative");
        this.secretExpirationPeriodLookupStrategy = FunctionSupport.constant((Object)period);
    }

    public void setSecretExpirationPeriodLookupStrategy(@Nonnull Function<ProfileRequestContext, Duration> strategy) {
        this.secretExpirationPeriodLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nullable
    public Map<String, MetadataPolicy> getMetadataPolicy(@Nullable ProfileRequestContext profileRequestContext) {
        return this.metadataPolicyLookupStrategy.apply(profileRequestContext);
    }

    public void setMetadataPolicy(@Nonnull Map<String, MetadataPolicy> policy) {
        this.metadataPolicyLookupStrategy = FunctionSupport.constant(policy);
    }

    public void setMetadataPolicyLookupStrategy(@Nonnull Function<ProfileRequestContext, Map<String, MetadataPolicy>> strategy) {
        this.metadataPolicyLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }
}

