/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.profile.config;

import com.google.common.base.Predicates;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.config.AuthenticationProfileConfiguration;
import net.shibboleth.idp.profile.config.AttributeResolvingProfileConfiguration;
import net.shibboleth.idp.profile.config.OverriddenIssuerProfileConfiguration;
import net.shibboleth.oidc.profile.config.OIDCProfileConfiguration;
import net.shibboleth.oidc.profile.oauth2.config.AbstractOAuth2FlowAwareProfileConfiguration;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Positive;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;

public abstract class AbstractOIDCSSOConfiguration
extends AbstractOAuth2FlowAwareProfileConfiguration
implements OIDCProfileConfiguration,
AuthenticationProfileConfiguration,
OverriddenIssuerProfileConfiguration,
AttributeResolvingProfileConfiguration {
    @Nonnull
    @NotEmpty
    public static final String PROTOCOL_URI = "http://openid.net/specs/openid-connect-core-1_0.html";
    @Nonnull
    private Function<ProfileRequestContext, String> issuerLookupStrategy = FunctionSupport.constant(null);
    @Nonnull
    private Predicate<ProfileRequestContext> resolveAttributesPredicate = Predicates.alwaysTrue();
    @Nonnull
    private Predicate<ProfileRequestContext> encryptionOptionalPredicate = Predicates.alwaysTrue();
    @Nonnull
    private Predicate<ProfileRequestContext> forcePKCEPredicate = Predicates.alwaysFalse();
    @Nonnull
    private Predicate<ProfileRequestContext> allowPKCEPlainPredicate = Predicates.alwaysFalse();
    @Nonnull
    private Function<ProfileRequestContext, Duration> idTokenLifetimeLookupStrategy = FunctionSupport.constant((Object)Duration.ofHours(1L));
    @Nonnull
    private Function<ProfileRequestContext, String> accessTokenTypeLookupStrategy = FunctionSupport.constant(null);
    @Nonnull
    private Function<ProfileRequestContext, Duration> accessTokenLifetimeLookupStrategy = FunctionSupport.constant((Object)Duration.ofMinutes(10L));
    @Nonnull
    private Function<ProfileRequestContext, Duration> refreshTokenLifetimeLookupStrategy = FunctionSupport.constant((Object)Duration.ofHours(2L));
    @Nonnull
    private Function<ProfileRequestContext, Set<String>> assertionAudiencesLookupStrategy = FunctionSupport.constant(null);
    @Nonnull
    private Function<ProfileRequestContext, Set<String>> alwaysIncludedAttributesLookupStrategy = FunctionSupport.constant(null);
    @Nonnull
    private Function<ProfileRequestContext, BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>>> idTokenManipulationStrategyLookupStrategy = FunctionSupport.constant(null);
    @Nonnull
    private Function<ProfileRequestContext, BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>>> accessTokenClaimsSetManipulationStrategyLookupStrategy = FunctionSupport.constant(null);

    public AbstractOIDCSSOConfiguration(@Nonnull @NotEmpty String profileId) {
        super(profileId);
    }

    @Nullable
    @NotEmpty
    public String getIssuer(@Nullable ProfileRequestContext profileRequestContext) {
        return this.issuerLookupStrategy.apply(profileRequestContext);
    }

    public void setIssuer(@Nullable @NotEmpty String issuer) {
        this.issuerLookupStrategy = FunctionSupport.constant((Object)issuer);
    }

    public void setIssuerLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.issuerLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Issuer lookup strategy cannot be null");
    }

    public boolean isResolveAttributes(@Nullable ProfileRequestContext profileRequestContext) {
        return this.resolveAttributesPredicate.test(profileRequestContext);
    }

    public void setResolveAttributes(boolean flag) {
        this.resolveAttributesPredicate = flag ? Predicates.alwaysTrue() : Predicates.alwaysFalse();
    }

    public void setResolveAttributesPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.resolveAttributesPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Resolve attributes predicate cannot be null");
    }

    public boolean isEncryptionOptional(@Nullable ProfileRequestContext profileRequestContext) {
        return this.encryptionOptionalPredicate.test(profileRequestContext);
    }

    public void setEncryptionOptional(boolean flag) {
        this.encryptionOptionalPredicate = flag ? Predicates.alwaysTrue() : Predicates.alwaysFalse();
    }

    public void setEncryptionOptionalPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.encryptionOptionalPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Encryption optional predicate cannot be null");
    }

    public boolean isForcePKCE(@Nullable ProfileRequestContext profileRequestContext) {
        return this.forcePKCEPredicate.test(profileRequestContext);
    }

    public void setForcePKCE(boolean flag) {
        this.forcePKCEPredicate = flag ? Predicates.alwaysTrue() : Predicates.alwaysFalse();
    }

    public void setForcePKCEPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.forcePKCEPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Condition cannot be null");
    }

    public boolean isAllowPKCEPlain(@Nullable ProfileRequestContext profileRequestContext) {
        return this.allowPKCEPlainPredicate.test(profileRequestContext);
    }

    public void setAllowPKCEPlain(boolean flag) {
        this.allowPKCEPlainPredicate = flag ? Predicates.alwaysTrue() : Predicates.alwaysFalse();
    }

    public void setAllowPKCEPlainPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.allowPKCEPlainPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Condition cannot be null");
    }

    @Nonnull
    @Positive
    public Duration getIDTokenLifetime(@Nullable ProfileRequestContext profileRequestContext) {
        Duration lifetime = this.idTokenLifetimeLookupStrategy.apply(profileRequestContext);
        Constraint.isTrue((lifetime != null && !lifetime.isZero() && !lifetime.isNegative() ? 1 : 0) != 0, (String)"ID token lifetime must be greater than 0");
        return lifetime;
    }

    public void setIDTokenLifetime(@Nonnull @Positive Duration lifetime) {
        Constraint.isTrue((lifetime != null && !lifetime.isZero() && !lifetime.isNegative() ? 1 : 0) != 0, (String)"ID token lifetime must be greater than 0");
        this.idTokenLifetimeLookupStrategy = FunctionSupport.constant((Object)lifetime);
    }

    public void setIDTokenLifetimeLookupStrategy(@Nonnull Function<ProfileRequestContext, Duration> strategy) {
        this.idTokenLifetimeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nullable
    @NotEmpty
    public String getAccessTokenType(@Nullable ProfileRequestContext profileRequestContext) {
        return this.accessTokenTypeLookupStrategy.apply(profileRequestContext);
    }

    public void setAccessTokenType(@Nullable @NotEmpty String type) {
        this.accessTokenTypeLookupStrategy = FunctionSupport.constant((Object)StringSupport.trimOrNull((String)type));
    }

    public void setAccessTokenTypeLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.accessTokenTypeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nonnull
    @Positive
    public Duration getAccessTokenLifetime(@Nullable ProfileRequestContext profileRequestContext) {
        Duration lifetime = this.accessTokenLifetimeLookupStrategy.apply(profileRequestContext);
        Constraint.isTrue((lifetime != null && !lifetime.isZero() && !lifetime.isNegative() ? 1 : 0) != 0, (String)"Access token lifetime must be greater than 0");
        return lifetime;
    }

    public void setAccessTokenLifetime(@Nonnull @Positive Duration lifetime) {
        Constraint.isTrue((lifetime != null && !lifetime.isZero() && !lifetime.isNegative() ? 1 : 0) != 0, (String)"Access token lifetime must be greater than 0");
        this.accessTokenLifetimeLookupStrategy = FunctionSupport.constant((Object)lifetime);
    }

    public void setAccessTokenLifetimeLookupStrategy(@Nullable Function<ProfileRequestContext, Duration> strategy) {
        this.accessTokenLifetimeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nonnull
    @Positive
    public Duration getRefreshTokenLifetime(@Nullable ProfileRequestContext profileRequestContext) {
        Duration lifetime = this.refreshTokenLifetimeLookupStrategy.apply(profileRequestContext);
        Constraint.isTrue((lifetime != null && !lifetime.isZero() && !lifetime.isNegative() ? 1 : 0) != 0, (String)"Refresh token lifetime must be greater than 0");
        return lifetime;
    }

    public void setRefreshTokenLifetime(@Nonnull @Positive Duration lifetime) {
        Constraint.isTrue((lifetime != null && !lifetime.isZero() && !lifetime.isNegative() ? 1 : 0) != 0, (String)"Refresh token lifetime must be greater than 0");
        this.refreshTokenLifetimeLookupStrategy = FunctionSupport.constant((Object)lifetime);
    }

    public void setRefreshTokenLifetimeLookupStrategy(@Nullable Function<ProfileRequestContext, Duration> strategy) {
        this.refreshTokenLifetimeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nonnull
    @NonnullElements
    @NotLive
    public Set<String> getAdditionalAudiencesForIdToken(@Nullable ProfileRequestContext profileRequestContext) {
        Set<String> audiences = this.assertionAudiencesLookupStrategy.apply(profileRequestContext);
        if (audiences != null) {
            return Set.copyOf(audiences);
        }
        return Collections.emptySet();
    }

    public void setAdditionalAudiencesForIdToken(@Nullable @NonnullElements Collection<String> audiences) {
        this.assertionAudiencesLookupStrategy = audiences == null || audiences.isEmpty() ? FunctionSupport.constant(null) : FunctionSupport.constant(Set.copyOf(StringSupport.normalizeStringCollection(audiences)));
    }

    public void setAdditionalAudiencesForIdTokenLookupStrategy(@Nonnull Function<ProfileRequestContext, Set<String>> strategy) {
        this.assertionAudiencesLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nonnull
    @NonnullElements
    @NotLive
    public Set<String> getAlwaysIncludedAttributes(@Nullable ProfileRequestContext profileRequestContext) {
        Set<String> attributes = this.alwaysIncludedAttributesLookupStrategy.apply(profileRequestContext);
        if (attributes != null) {
            return Set.copyOf(attributes);
        }
        return Collections.emptySet();
    }

    public void setAlwaysIncludedAttributes(@Nullable @NonnullElements Collection<String> attributes) {
        this.alwaysIncludedAttributesLookupStrategy = attributes == null || attributes.isEmpty() ? FunctionSupport.constant(null) : FunctionSupport.constant(Set.copyOf(StringSupport.normalizeStringCollection(attributes)));
    }

    public void setAlwaysIncludedAttributesLookupStrategy(@Nonnull Function<ProfileRequestContext, Set<String>> strategy) {
        this.alwaysIncludedAttributesLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nonnull
    public BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>> getIDTokenManipulationStrategy(@Nullable ProfileRequestContext profileRequestContext) {
        return this.idTokenManipulationStrategyLookupStrategy.apply(profileRequestContext);
    }

    public void setIDTokenManipulationStrategy(@Nullable BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>> strategy) {
        this.idTokenManipulationStrategyLookupStrategy = FunctionSupport.constant(strategy);
    }

    public void setIDTokenManipulationStrategyLookupStrategy(@Nonnull Function<ProfileRequestContext, BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>>> strategy) {
        this.idTokenManipulationStrategyLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nonnull
    public BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>> getAccessTokenClaimsSetManipulationStrategy(@Nullable ProfileRequestContext profileRequestContext) {
        return this.accessTokenClaimsSetManipulationStrategyLookupStrategy.apply(profileRequestContext);
    }

    public void setAccessTokenClaimsSetManipulationStrategy(@Nullable BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>> strategy) {
        this.accessTokenClaimsSetManipulationStrategyLookupStrategy = FunctionSupport.constant(strategy);
    }

    public void setAccessTokenClaimsSetManipulationStrategyLookupStrategy(@Nonnull Function<ProfileRequestContext, BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>>> strategy) {
        this.accessTokenClaimsSetManipulationStrategyLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }
}

