/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.profile.config;

import java.time.Duration;
import java.util.Collections;
import net.shibboleth.idp.profile.config.SecurityConfiguration;
import net.shibboleth.oidc.authn.principal.AuthenticationContextClassReferencePrincipal;
import net.shibboleth.oidc.profile.config.OIDCAuthorizationConfiguration;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class OIDCCoreProtocolConfigurationTest {
    private OIDCAuthorizationConfiguration config;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.config = new OIDCAuthorizationConfiguration();
        this.config.setSecurityConfiguration(new SecurityConfiguration());
        this.config.initialize();
    }

    @Test
    public void testInitialState() throws ComponentInitializationException {
        Assert.assertEquals((String)this.config.getId(), (String)"http://shibboleth.net/ns/profiles/oidc/sso/browser");
        Assert.assertTrue((boolean)this.config.getAuthenticationFlows(null).isEmpty());
        Assert.assertTrue((boolean)this.config.getPostAuthenticationFlows(null).isEmpty());
        Assert.assertTrue((boolean)this.config.getDefaultAuthenticationMethods(null).isEmpty());
        Assert.assertTrue((boolean)this.config.getAdditionalAudiencesForIdToken(null).isEmpty());
        Assert.assertEquals((Object)this.config.getAuthorizeCodeLifetime(null), (Object)Duration.ofMinutes(5L));
        Assert.assertEquals((Object)this.config.getIDTokenLifetime(null), (Object)Duration.ofHours(1L));
        Assert.assertEquals((Object)this.config.getAccessTokenLifetime(null), (Object)Duration.ofMinutes(10L));
        Assert.assertEquals((Object)this.config.getRefreshTokenLifetime(null), (Object)Duration.ofHours(2L));
        Assert.assertFalse((boolean)this.config.isAcrRequestAlwaysEssential(null));
        Assert.assertTrue((boolean)this.config.getAdditionalAudiencesForIdToken(null).isEmpty());
        Assert.assertTrue((boolean)this.config.isResolveAttributes(null));
    }

    @Test
    void testsetResolveAttributes() {
        Assert.assertTrue((boolean)this.config.isResolveAttributes(null));
        this.config.setResolveAttributes(false);
        Assert.assertFalse((boolean)this.config.isResolveAttributes(null));
    }

    @Test
    void testsetDefaultAuthenticationMethods() {
        Assert.assertTrue((boolean)this.config.getDefaultAuthenticationMethods(null).isEmpty());
        this.config.setDefaultAuthenticationMethods(Collections.singletonList(new AuthenticationContextClassReferencePrincipal("value")));
        Assert.assertTrue((boolean)this.config.getDefaultAuthenticationMethods(null).contains(new AuthenticationContextClassReferencePrincipal("value")));
    }

    @Test
    void testsetRefreshTokenLifetime() {
        this.config.setRefreshTokenLifetime(Duration.ofMillis(100L));
        Assert.assertEquals((Object)this.config.getRefreshTokenLifetime(null), (Object)Duration.ofMillis(100L));
    }

    @Test
    void testsetAccessTokenLifetime() {
        this.config.setAccessTokenLifetime(Duration.ofMillis(100L));
        Assert.assertEquals((Object)this.config.getAccessTokenLifetime(null), (Object)Duration.ofMillis(100L));
    }

    @Test
    void testsetAuthorizeCodeLifetime() {
        this.config.setAuthorizeCodeLifetime(Duration.ofMillis(100L));
        Assert.assertEquals((Object)this.config.getAuthorizeCodeLifetime(null), (Object)Duration.ofMillis(100L));
    }

    @Test
    void testsetIDTokenLifetime() {
        this.config.setIDTokenLifetime(Duration.ofMillis(100L));
        Assert.assertEquals((Object)this.config.getIDTokenLifetime(null), (Object)Duration.ofMillis(100L));
    }

    @Test
    void testsetAcrRequestAlwaysEssential() {
        Assert.assertFalse((boolean)this.config.isAcrRequestAlwaysEssential(null));
        this.config.setAcrRequestAlwaysEssential(true);
        Assert.assertTrue((boolean)this.config.isAcrRequestAlwaysEssential(null));
    }

    @Test
    void testsetAdditionalAudiencesForIdToken() {
        Assert.assertTrue((boolean)this.config.getAdditionalAudiencesForIdToken(null).isEmpty());
        this.config.setAdditionalAudiencesForIdToken(Collections.singletonList("value"));
        Assert.assertTrue((boolean)this.config.getAdditionalAudiencesForIdToken(null).contains("value"));
    }

    @Test
    void testsetAuthenticationFlows() {
        Assert.assertTrue((boolean)this.config.getAuthenticationFlows(null).isEmpty());
        this.config.setAuthenticationFlows(Collections.singletonList("value"));
        Assert.assertTrue((boolean)this.config.getAuthenticationFlows(null).contains("value"));
    }

    @Test
    void testsetPostAuthenticationFlows() {
        Assert.assertTrue((boolean)this.config.getPostAuthenticationFlows(null).isEmpty());
        this.config.setPostAuthenticationFlows(Collections.singletonList("value"));
        Assert.assertTrue((boolean)this.config.getPostAuthenticationFlows(null).contains("value"));
    }
}

