/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.profile.spring.relyingparty.metadata.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.metadata.ProviderMetadataProviderContainer;
import net.shibboleth.oidc.metadata.ProviderMetadataResolver;
import net.shibboleth.oidc.metadata.impl.ChainingProviderMetadataResolver;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import net.shibboleth.utilities.java.support.service.ServiceException;
import net.shibboleth.utilities.java.support.service.ServiceableComponent;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.context.ApplicationContext;

public class ProviderMetadataResolverServiceStrategy
extends AbstractIdentifiableInitializableComponent
implements Function<ApplicationContext, ServiceableComponent<ProviderMetadataResolver>> {
    @Override
    @Nullable
    public ServiceableComponent<ProviderMetadataResolver> apply(@Nonnull ApplicationContext appContext) {
        Collection containers = appContext.getBeansOfType(ProviderMetadataProviderContainer.class).values();
        if (containers.isEmpty()) {
            throw new ServiceException("Reload did not produce any bean of type " + ProviderMetadataProviderContainer.class.getName());
        }
        if (1 == containers.size()) {
            return (ServiceableComponent)containers.iterator().next();
        }
        for (ProviderMetadataProviderContainer container : containers) {
            try {
                container.initialize();
            }
            catch (ComponentInitializationException e) {
                throw new BeanCreationException("could not preinitialize , provider metadata provider " + container.getId(), (Throwable)e);
            }
        }
        ArrayList containerList = new ArrayList(containers.size());
        containerList.addAll(containers);
        Collections.sort(containerList);
        ChainingProviderMetadataResolver chain = new ChainingProviderMetadataResolver();
        try {
            chain.setResolvers(containerList.stream().map(ProviderMetadataProviderContainer::getEmbeddedResolver).collect(Collectors.toList()));
            chain.setId("MultiFileResolverFor:" + containers.size() + ":Resources");
            chain.initialize();
            ProviderMetadataProviderContainer result = new ProviderMetadataProviderContainer();
            result.setEmbeddedResolver((ProviderMetadataResolver)chain);
            result.setApplicationContext(appContext);
            result.initialize();
            return result;
        }
        catch (ComponentInitializationException | ResolverException e) {
            throw new ServiceException("Chaining constructor create failed", (Exception)e);
        }
    }
}

