/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.profile.spring.relyingparty.metadata.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.shibboleth.oidc.metadata.ClientInformationResolver;
import net.shibboleth.oidc.metadata.RelyingPartyClientInformationProvider;
import net.shibboleth.oidc.metadata.impl.ChainingClientInformationResolver;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import net.shibboleth.utilities.java.support.service.ServiceException;
import net.shibboleth.utilities.java.support.service.ServiceableComponent;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.context.ApplicationContext;

public class ClientInformationResolverServiceStrategy
extends AbstractIdentifiableInitializableComponent
implements Function<ApplicationContext, ServiceableComponent<ClientInformationResolver>> {
    @Override
    @Nullable
    public ServiceableComponent<ClientInformationResolver> apply(@Nullable ApplicationContext appContext) {
        Collection resolvers = appContext.getBeansOfType(RelyingPartyClientInformationProvider.class).values();
        if (resolvers.isEmpty()) {
            throw new ServiceException("Reload did not produce any bean of type" + RelyingPartyClientInformationProvider.class.getName());
        }
        if (1 == resolvers.size()) {
            return (ServiceableComponent)resolvers.iterator().next();
        }
        for (RelyingPartyClientInformationProvider resolver : resolvers) {
            try {
                resolver.initialize();
            }
            catch (ComponentInitializationException e) {
                throw new BeanCreationException("could not preinitialize , client information provider " + resolver.getId(), (Throwable)e);
            }
        }
        ArrayList resolverList = new ArrayList(resolvers.size());
        resolverList.addAll(resolvers);
        Collections.sort(resolverList);
        ChainingClientInformationResolver chain = new ChainingClientInformationResolver();
        try {
            chain.setResolvers(resolverList);
            chain.setId("MultiFileResolverFor:" + resolvers.size() + ":Resources");
            chain.initialize();
            RelyingPartyClientInformationProvider result = new RelyingPartyClientInformationProvider();
            result.setEmbeddedResolver((ClientInformationResolver)chain);
            result.setApplicationContext(appContext);
            result.initialize();
            return result;
        }
        catch (ComponentInitializationException | ResolverException e) {
            throw new ServiceException("Chaining constructor create failed", (Exception)e);
        }
    }
}

