/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.metadata.policy.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.metadata.policy.MetadataPolicy;
import net.shibboleth.oidc.metadata.policy.impl.MetadataPolicyHelper;
import net.shibboleth.utilities.java.support.collection.Pair;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMetadataPolicyEnforcer
implements BiFunction<Object, MetadataPolicy, Pair<Object, Boolean>> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DefaultMetadataPolicyEnforcer.class);

    @Override
    @Nonnull
    public Pair<Object, Boolean> apply(@Nullable Object candidate, @Nullable MetadataPolicy policy) {
        Object result;
        if (policy == null) {
            return new Pair(candidate, (Object)Boolean.TRUE);
        }
        Object value = policy.getValue();
        if (value != null) {
            return new Pair(value, (Object)Boolean.TRUE);
        }
        Object add = policy.getAdd();
        if (add != null) {
            try {
                result = this.applyAddOperator(candidate, add);
            }
            catch (ConstraintViolationException e) {
                this.log.warn("Could not add values to candidate: {}", (Object)e.getMessage());
                return new Pair(candidate, (Object)Boolean.FALSE);
            }
        } else {
            result = candidate == null ? policy.getDefaultValue() : candidate;
        }
        boolean validation = this.doValueChecks(result, policy);
        return new Pair(result, (Object)validation);
    }

    @Nonnull
    protected Object applyAddOperator(@Nullable Object candidate, @Nonnull Object add) throws ConstraintViolationException {
        if (candidate != null) {
            Collection collection;
            if (candidate instanceof List) {
                ArrayList<Object> list = new ArrayList<Object>((List)candidate);
                if (add instanceof Collection) {
                    list.addAll((Collection)add);
                } else {
                    list.add(add);
                }
                return list;
            }
            if (add instanceof Collection && ((collection = (Collection)add).size() > 1 || !collection.contains(candidate))) {
                throw new ConstraintViolationException("The array-values in add (" + add + ") not compliant with the single existing value " + candidate);
            }
            if (!add.equals(candidate)) {
                throw new ConstraintViolationException("The single-value in add (" + add + ") does not match with the single existing value " + candidate);
            }
            return candidate;
        }
        if (add instanceof Collection) {
            return List.copyOf((Collection)add);
        }
        return add;
    }

    protected boolean doValueChecks(@Nullable Object candidate, @Nonnull MetadataPolicy policy) {
        boolean validation = true;
        if (candidate != null) {
            List supersetOfValues;
            List subsetOfValues;
            List oneOfValues = policy.getOneOfValues();
            if (oneOfValues != null) {
                if (candidate instanceof List) {
                    List list = (List)candidate;
                    if (list.size() > 1) {
                        this.log.warn("The candidate {} contains multiple values, not compatible with one_of", candidate);
                        validation = false;
                    } else if (oneOfValues != null && !MetadataPolicyHelper.isSubsetOfValues(candidate, oneOfValues)) {
                        this.log.warn("The candidate {} is not compatible with one_of {}", candidate, (Object)oneOfValues);
                        validation = false;
                    }
                } else if (!oneOfValues.contains(candidate)) {
                    this.log.warn("The candidate {} does not contain a value required by one_of {}", candidate, (Object)oneOfValues);
                    validation = false;
                }
            }
            if ((subsetOfValues = policy.getSubsetOfValues()) != null && !MetadataPolicyHelper.isSubsetOfValues(candidate, subsetOfValues)) {
                this.log.warn("The candidate {} is not a subset as required by subset_of {}", candidate, (Object)subsetOfValues);
                validation = false;
            }
            if ((supersetOfValues = policy.getSupersetOfValues()) != null && !MetadataPolicyHelper.isSupersetOfValues(candidate, supersetOfValues)) {
                this.log.warn("The candidate {} is not a superset as required by superset_of {}", candidate, (Object)supersetOfValues);
                validation = false;
            }
            if (!this.verifyRegexp(candidate, policy.getRegexp())) {
                validation = false;
            }
        } else if (policy.isEssential()) {
            this.log.warn("No value even though essential is set to true");
            validation = false;
        }
        return validation;
    }

    protected boolean verifyRegexp(@Nonnull Object candidate, @Nullable String regexp) {
        if (regexp != null) {
            if (candidate instanceof List) {
                for (Object item : (List)candidate) {
                    if (Pattern.matches(regexp, item.toString())) continue;
                    this.log.warn("One of candidate values {} does not match the regex {}", item, (Object)regexp);
                    return false;
                }
            } else if (!Pattern.matches(regexp, candidate.toString())) {
                this.log.warn("The candidate value {} does not match the regex {}", candidate, (Object)regexp);
                return false;
            }
        }
        return true;
    }
}

