/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.metadata.keyinfo.ext.impl.provider;

import com.nimbusds.oauth2.sdk.auth.Secret;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.metadata.ClientSecretValueResolver;
import net.shibboleth.oidc.metadata.criterion.ClientSecretReferenceCriterion;
import net.shibboleth.oidc.saml.xmlobject.ClientSecretKeyReference;
import net.shibboleth.oidc.security.credential.BasicNimbusSecretCredential;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.collection.LazySet;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.KeyInfoResolutionContext;
import org.opensaml.xmlsec.keyinfo.impl.provider.AbstractKeyInfoProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientSecretReferenceProvider
extends AbstractKeyInfoProvider {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ClientSecretReferenceProvider.class);
    @Nonnull
    @NotEmpty
    private Collection<ClientSecretValueResolver> clientSecretValueResolvers;

    public ClientSecretReferenceProvider(@Nullable @NotEmpty Collection<ClientSecretValueResolver> valueResolvers) {
        this.clientSecretValueResolvers = valueResolvers != null ? List.copyOf(valueResolvers) : Collections.emptyList();
    }

    @Nullable
    public Collection<Credential> process(@Nonnull KeyInfoCredentialResolver resolver, @Nonnull XMLObject keyInfoChild, @Nullable CriteriaSet criteriaSet, @Nonnull KeyInfoResolutionContext kiContext) throws SecurityException {
        ClientSecretKeyReference clientSecretReference = this.getClientSecret(keyInfoChild);
        if (clientSecretReference == null || StringSupport.trimOrNull((String)clientSecretReference.getValue()) == null) {
            this.log.debug("No value found for the ClientSecretReferenceKey element");
            return null;
        }
        String secretReference = clientSecretReference.getValue();
        for (ClientSecretValueResolver valueResolver : this.clientSecretValueResolvers) {
            this.log.trace("Attempting to resolve value for {} with {}", (Object)secretReference, (Object)valueResolver.getId());
            CriteriaSet criteria = new CriteriaSet(new Criterion[]{new ClientSecretReferenceCriterion(secretReference)});
            try {
                String value = (String)valueResolver.resolveSingle((Object)criteria);
                if (value == null) continue;
                this.log.debug("Found value for {} with {}", (Object)secretReference, (Object)valueResolver.getId());
                LazySet credentials = new LazySet();
                credentials.add((Object)new BasicNimbusSecretCredential(new Secret(value)));
                return credentials;
            }
            catch (ResolverException e) {
                this.log.warn("Client secret value resolution failed", (Throwable)e);
            }
        }
        this.log.warn("No values could be resolved for the client secret reference {}", (Object)clientSecretReference.getValue());
        return null;
    }

    public boolean handles(@Nonnull XMLObject keyInfoChild) {
        return this.getClientSecret(keyInfoChild) != null;
    }

    @Nullable
    protected ClientSecretKeyReference getClientSecret(@Nonnull XMLObject xmlObject) {
        if (xmlObject instanceof ClientSecretKeyReference) {
            return (ClientSecretKeyReference)xmlObject;
        }
        return null;
    }
}

