/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.metadata.impl;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.resolver.AttributeResolver;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.oidc.metadata.criterion.ClientSecretReferenceCriterion;
import net.shibboleth.oidc.metadata.impl.AbstractClientSecretValueResolver;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.collection.LazySet;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import net.shibboleth.utilities.java.support.service.ReloadableService;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResolverServiceClientSecretValueResolver
extends AbstractClientSecretValueResolver {
    private final Logger log = LoggerFactory.getLogger(ResolverServiceClientSecretValueResolver.class);
    @NonnullAfterInit
    private ReloadableService<AttributeResolver> service;
    @Nonnull
    private List<String> attributeIds = Collections.emptyList();

    public void setAttributeResolver(@Nonnull ReloadableService<AttributeResolver> resolver) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.service = (ReloadableService)Constraint.isNotNull(resolver, (String)"Attribute resolver service can not be null");
    }

    @NonnullAfterInit
    public ReloadableService<AttributeResolver> getAttributeResolver() {
        return this.service;
    }

    public void setAttributeIds(@Nonnull List<String> ids) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.attributeIds = (List)Constraint.isNotEmpty(ids, (String)"The list of attribute ids cannot be empty");
    }

    @Nonnull
    public List<String> getAttributeIds() {
        return this.attributeIds;
    }

    @Nonnull
    public Iterable<String> resolve(@Nonnull CriteriaSet criteria) throws ResolverException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ClientSecretReferenceCriterion referenceCriterion = (ClientSecretReferenceCriterion)criteria.get(ClientSecretReferenceCriterion.class);
        Constraint.isNotNull((Object)referenceCriterion, (String)"The client secret reference criterion must be included in the criteria.");
        ProfileRequestContext profileRequestContext = new ProfileRequestContext();
        AttributeResolutionContext resolutionContext = (AttributeResolutionContext)profileRequestContext.getSubcontext(AttributeResolutionContext.class, true);
        resolutionContext.setPrincipal(referenceCriterion.getSecretReference());
        resolutionContext.setResolutionLabel(((Object)((Object)this)).getClass().getSimpleName());
        if (criteria.contains(EntityIdCriterion.class)) {
            resolutionContext.setAttributeRecipientID(((EntityIdCriterion)criteria.get(EntityIdCriterion.class)).getEntityId());
        }
        resolutionContext.resolveAttributes(this.service);
        Map resolvedAttributes = resolutionContext.getResolvedIdPAttributes();
        LazySet result = new LazySet();
        for (String attributeId : this.attributeIds) {
            if (!resolvedAttributes.containsKey(attributeId)) continue;
            for (IdPAttributeValue value : ((IdPAttribute)resolvedAttributes.get(attributeId)).getValues()) {
                if (!(value instanceof StringAttributeValue)) continue;
                this.log.debug("Found a value for reference '{}' via attribute ID {}", (Object)referenceCriterion.getSecretReference(), (Object)attributeId);
                result.add((Object)((StringAttributeValue)value).getValue());
            }
        }
        return result;
    }

    @Nullable
    public String resolveSingle(@Nonnull CriteriaSet criteria) throws ResolverException {
        Iterator<String> iterator = this.resolve(criteria).iterator();
        return iterator.hasNext() ? iterator.next() : null;
    }

    protected void doDestroy() {
        this.service = null;
        this.attributeIds = null;
        super.doDestroy();
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.getAttributeResolver() == null) {
            throw new ComponentInitializationException("Attribute resolver service can not be null");
        }
    }
}

