/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.metadata.impl;

import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import java.util.Collections;
import javax.annotation.Nonnull;
import net.shibboleth.oidc.metadata.ProviderMetadataResolver;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import net.shibboleth.utilities.java.support.service.ReloadableService;
import net.shibboleth.utilities.java.support.service.ServiceableComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReloadingProviderMetadataProvider
extends AbstractIdentifiableInitializableComponent
implements ProviderMetadataResolver {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ReloadingProviderMetadataProvider.class);
    private final ReloadableService<ProviderMetadataResolver> service;

    public ReloadingProviderMetadataProvider(@Nonnull ReloadableService<ProviderMetadataResolver> resolverService) {
        this.service = (ReloadableService)Constraint.isNotNull(resolverService, (String)"ProviderMetadataResolver Service cannot be null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<OIDCProviderMetadata> resolve(@Nonnull CriteriaSet criteria) throws ResolverException {
        block7: {
            ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
            ServiceableComponent component = null;
            try {
                component = this.service.getServiceableComponent();
                if (null == component) {
                    this.log.error("ReloadingProviderMetadataProvider '{}': Error accessing underlying source: Invalid configuration.", (Object)this.getId());
                    break block7;
                }
                ProviderMetadataResolver resolver = (ProviderMetadataResolver)component.getComponent();
                Iterable iterable = resolver.resolve((Object)criteria);
                return iterable;
            }
            catch (ResolverException e) {
                this.log.error("ProviderMetadataResolver '{}': Error during resolution", (Object)this.getId(), (Object)e);
            }
            finally {
                if (null != component) {
                    component.unpinComponent();
                }
            }
        }
        return Collections.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OIDCProviderMetadata resolveSingle(@Nonnull CriteriaSet criteria) throws ResolverException {
        block7: {
            ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
            ServiceableComponent component = null;
            try {
                component = this.service.getServiceableComponent();
                if (null == component) {
                    this.log.error("ReloadingProviderMetadataProvider '{}': Error accessing underlying source: Invalid configuration.", (Object)this.getId());
                    break block7;
                }
                ProviderMetadataResolver resolver = (ProviderMetadataResolver)component.getComponent();
                OIDCProviderMetadata oIDCProviderMetadata = (OIDCProviderMetadata)resolver.resolveSingle((Object)criteria);
                return oIDCProviderMetadata;
            }
            catch (ResolverException e) {
                this.log.error("ProviderMetadataResolver '{}': Error during resolution", (Object)this.getId(), (Object)e);
            }
            finally {
                if (null != component) {
                    component.unpinComponent();
                }
            }
        }
        return null;
    }
}

