/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.metadata.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.metadata.criterion.ClientSecretReferenceCriterion;
import net.shibboleth.oidc.metadata.impl.AbstractClientSecretValueResolver;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.collection.LazySet;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class PropertiesClientSecretValueResolver
extends AbstractClientSecretValueResolver {
    private final Logger log = LoggerFactory.getLogger(PropertiesClientSecretValueResolver.class);
    @NonnullAfterInit
    private Resource propertiesResource;

    public void setResource(@Nonnull Resource resource) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.propertiesResource = (Resource)Constraint.isNotNull((Object)resource, (String)"Properties resource cannot be null");
        Properties properties = new Properties();
        try {
            properties.load(this.propertiesResource.getInputStream());
        }
        catch (IOException e) {
            this.log.error("Could not read the properties from the given resource", (Throwable)e);
            throw new ConstraintViolationException("The properties resource must be readable");
        }
    }

    @NonnullAfterInit
    public Resource getResource() {
        return this.propertiesResource;
    }

    @Nonnull
    public Iterable<String> resolve(@Nonnull CriteriaSet criteria) throws ResolverException {
        String value = this.resolveSingle(criteria);
        if (value != null) {
            LazySet result = new LazySet();
            result.add((Object)value);
            return result;
        }
        return Collections.emptySet();
    }

    @Nullable
    public String resolveSingle(@Nonnull CriteriaSet criteria) throws ResolverException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ClientSecretReferenceCriterion criterion = (ClientSecretReferenceCriterion)criteria.get(ClientSecretReferenceCriterion.class);
        Properties properties = new Properties();
        try {
            properties.load(this.propertiesResource.getInputStream());
        }
        catch (IOException e) {
            this.log.error("Could not read the properties from the resource", (Throwable)e);
            throw new ResolverException((Exception)e);
        }
        return properties.getProperty(criterion.getSecretReference());
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.getResource() == null) {
            throw new ComponentInitializationException("Properties resource cannot be null");
        }
    }

    protected void doDestroy() {
        this.propertiesResource = null;
        super.doDestroy();
    }
}

