/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.metadata.impl;

import com.google.common.net.MediaType;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import java.io.IOException;
import java.util.Set;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.oidc.metadata.criterion.IssuerIDCriterion;
import net.shibboleth.oidc.metadata.impl.AbstractDynamicHTTPFetchingStrategy;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.net.MediaTypeSupport;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

@ThreadSafe
public class HTTPProviderConfigurationFetchingStrategy
extends AbstractDynamicHTTPFetchingStrategy<OIDCProviderMetadata> {
    @Nonnull
    private static final MediaType CONTENT_TYPE = MediaType.JSON_UTF_8;
    @Nonnull
    @NotEmpty
    private static final String DEFAULT_OPENID_PROVIDER_WELL_KNOWN_PATH = "/.well-known/openid-configuration";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(HTTPProviderConfigurationFetchingStrategy.class);
    @Nonnull
    @NotEmpty
    private String wellKnownPath = "/.well-known/openid-configuration";
    @Nonnull
    private BiFunction<Issuer, String, String> wellKnownLocationCompositionStrategy = new DefaultWellKnownPathCompositionStrategy();

    protected HTTPProviderConfigurationFetchingStrategy(@Nonnull HttpClient client, @Nonnull ResponseHandler<OIDCProviderMetadata> handler) {
        super(client, handler);
    }

    public void setWellKnownPath(@Nonnull @NotEmpty String path) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.wellKnownPath = Constraint.isNotEmpty((String)path, (String)"Well-know path can not be null");
    }

    public void setWellKnownLocationCompositionStrategy(@Nonnull BiFunction<Issuer, String, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.wellKnownLocationCompositionStrategy = (BiFunction)Constraint.isNotNull(strategy, (String)"Well known location composition strategy can not be null");
    }

    @Override
    protected String buildRequestURL(@Nonnull CriteriaSet criteria) {
        if (criteria.contains(IssuerIDCriterion.class)) {
            String url = this.wellKnownLocationCompositionStrategy.apply(((IssuerIDCriterion)criteria.get(IssuerIDCriterion.class)).getIssuerID(), this.wellKnownPath);
            this.log.debug("URL generated by request builder was: {}", (Object)url);
            return url;
        }
        return null;
    }

    @Immutable
    @ThreadSafe
    public static final class OIDCProviderMetadataResponseHandler
    implements ResponseHandler<OIDCProviderMetadata> {
        @Nonnull
        private final Logger log = LoggerFactory.getLogger(OIDCProviderMetadataResponseHandler.class);

        @Nullable
        public OIDCProviderMetadata handleResponse(HttpResponse response) throws IOException {
            int httpStatusCode = response.getStatusLine().getStatusCode();
            String currentRequestURI = MDC.get((String)AbstractDynamicHTTPFetchingStrategy.MDC_ATTRIB_CURRENT_REQUEST_URI);
            if (httpStatusCode == 304) {
                this.log.debug("Metadata document from '{}' has not changed since last retrieval", (Object)currentRequestURI);
                return null;
            }
            if (httpStatusCode != 200) {
                this.log.warn("Non-ok status code '{}' returned from remote metadata source: {}", (Object)httpStatusCode, (Object)currentRequestURI);
                return null;
            }
            try {
                this.validateHttpResponse(response);
            }
            catch (ResolverException e) {
                this.log.error("Problem validating dynamic OIDC metadata HTTP response", (Throwable)e);
                return null;
            }
            try {
                String jsonDocument = EntityUtils.toString((HttpEntity)response.getEntity());
                return OIDCProviderMetadata.parse((String)jsonDocument);
            }
            catch (Exception e) {
                this.log.error("Error parsing HTTP response stream", (Throwable)e);
                return null;
            }
        }

        protected void validateHttpResponse(@Nonnull HttpResponse response) throws ResolverException {
            String contentTypeValue = null;
            Header contentType = response.getEntity().getContentType();
            if (contentType != null && contentType.getValue() != null) {
                contentTypeValue = StringSupport.trimOrNull((String)contentType.getValue());
            }
            this.log.debug("Saw raw Content-Type from response header '{}'", contentTypeValue);
            if (!MediaTypeSupport.validateContentType((String)contentTypeValue, Set.of(CONTENT_TYPE), (boolean)true, (boolean)false)) {
                throw new ResolverException("HTTP response specified an unsupported Content-Type MIME type: " + contentTypeValue);
            }
        }
    }

    @Immutable
    @ThreadSafe
    private static final class DefaultWellKnownPathCompositionStrategy
    implements BiFunction<Issuer, String, String> {
        @Nonnull
        private final Logger log = LoggerFactory.getLogger(DefaultWellKnownPathCompositionStrategy.class);

        private DefaultWellKnownPathCompositionStrategy() {
        }

        @Override
        @Nullable
        public String apply(@Nonnull Issuer issuer, @Nonnull @NotEmpty String wellKnownPath) {
            String normalizedIssuer = StringUtils.removeEnd((String)issuer.getValue(), (String)"/");
            StringBuilder builder = new StringBuilder();
            builder.append(normalizedIssuer).append(wellKnownPath);
            return builder.toString();
        }
    }
}

