/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.metadata.impl;

import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import java.lang.invoke.CallSite;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.metadata.ProviderMetadataResolver;
import net.shibboleth.oidc.metadata.RefreshableProviderMetadataResolver;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChainingProviderMetadataResolver
extends AbstractIdentifiableInitializableComponent
implements RefreshableProviderMetadataResolver {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ChainingProviderMetadataResolver.class);
    @Nonnull
    @NonnullElements
    private List<ProviderMetadataResolver> resolvers = Collections.emptyList();

    @Nonnull
    @NonnullElements
    @Unmodifiable
    @NotLive
    public List<ProviderMetadataResolver> getResolvers() {
        return this.resolvers;
    }

    public void setResolvers(@Nullable @NonnullElements List<? extends ProviderMetadataResolver> newResolvers) throws ResolverException {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.resolvers = newResolvers == null || newResolvers.isEmpty() ? Collections.emptyList() : List.copyOf(newResolvers);
    }

    @Nullable
    public OIDCProviderMetadata resolveSingle(@Nullable CriteriaSet criteria) throws ResolverException {
        Iterator<OIDCProviderMetadata> iterator;
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        Iterable<OIDCProviderMetadata> iterable = this.resolve(criteria);
        if (iterable != null && (iterator = iterable.iterator()) != null && iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    @Nonnull
    public Iterable<OIDCProviderMetadata> resolve(@Nullable CriteriaSet criteria) throws ResolverException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        for (ProviderMetadataResolver resolver : this.resolvers) {
            try {
                Iterable providerMetadatas = resolver.resolve((Object)criteria);
                if (providerMetadatas == null || !providerMetadatas.iterator().hasNext()) continue;
                return providerMetadatas;
            }
            catch (ResolverException e) {
                this.log.warn("Error retrieving provider metadata from resolver of type {}, proceeding to next resolver", (Object)resolver.getClass().getName(), (Object)e);
            }
        }
        return Collections.emptyList();
    }

    public void refresh() throws ResolverException {
        for (ProviderMetadataResolver resolver : this.resolvers) {
            if (!(resolver instanceof RefreshableProviderMetadataResolver)) continue;
            ((RefreshableProviderMetadataResolver)resolver).refresh();
        }
    }

    @Nullable
    public Instant getLastUpdate() {
        Instant ret = null;
        for (ProviderMetadataResolver resolver : this.resolvers) {
            if (!(resolver instanceof RefreshableProviderMetadataResolver)) continue;
            Instant lastUpdate = ((RefreshableProviderMetadataResolver)resolver).getLastUpdate();
            if (ret != null && !ret.isBefore(lastUpdate)) continue;
            ret = lastUpdate;
        }
        return ret;
    }

    @Nullable
    public Instant getLastRefresh() {
        Instant ret = null;
        for (ProviderMetadataResolver resolver : this.resolvers) {
            if (!(resolver instanceof RefreshableProviderMetadataResolver)) continue;
            Instant lastRefresh = ((RefreshableProviderMetadataResolver)resolver).getLastRefresh();
            if (ret != null && !ret.isBefore(lastRefresh)) continue;
            ret = lastRefresh;
        }
        return ret;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.resolvers == null) {
            this.log.warn("ProviderMetadataResolver was not configured with any member ProviderMetadataResolvers");
            this.resolvers = Collections.emptyList();
        } else {
            ArrayList<CallSite> resolverDetails = new ArrayList<CallSite>();
            for (ProviderMetadataResolver resolver : this.resolvers) {
                resolverDetails.add((CallSite)((Object)(resolver.getId() + ": " + this.countClients(resolver) + " clients")));
            }
            this.log.info("ChainingProviderMetadataResolver was configured with the following resolvers: {}", resolverDetails);
        }
    }

    protected void doDestroy() {
        super.doDestroy();
        this.resolvers = Collections.emptyList();
    }

    protected int countClients(ProviderMetadataResolver resolver) {
        Iterable iterable;
        int count = 0;
        try {
            iterable = resolver.resolve((Object)new CriteriaSet());
        }
        catch (ResolverException e) {
            this.log.warn("ChainingProviderMetadataResolver could not count clients for {}", (Object)resolver.getId());
            return 0;
        }
        Iterator iterator = iterable.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            ++count;
        }
        return count;
    }
}

