/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.metadata.impl;

import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.metadata.AbstractEvaluableMetadataCriterion;
import net.shibboleth.oidc.metadata.OIDCMetadataResolver;
import net.shibboleth.oidc.metadata.cache.MetadataCache;
import net.shibboleth.oidc.metadata.cache.MetadataCacheException;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.CriterionPredicateRegistry;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import net.shibboleth.utilities.java.support.resolver.ResolverSupport;
import org.opensaml.core.criterion.SatisfyAnyCriterion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOIDCMetadataResolver<MetadataIdentifier, MetadataType>
extends AbstractIdentifiableInitializableComponent
implements OIDCMetadataResolver<MetadataType> {
    private final Logger log = LoggerFactory.getLogger(AbstractOIDCMetadataResolver.class);
    private String logPrefix;
    @Nonnull
    private final MetadataCache<MetadataType> cache;
    private boolean satisfyAnyPredicates;
    @NonnullAfterInit
    private CriterionPredicateRegistry<MetadataType> criterionPredicateRegistry;
    private boolean failFastInitialization = true;

    protected AbstractOIDCMetadataResolver(@Nonnull MetadataCache<MetadataType> metadataCache) {
        this.cache = (MetadataCache)Constraint.isNotNull(metadataCache, (String)"Metadata cache can not be null");
    }

    @Nonnull
    @NotEmpty
    protected String getLogPrefix() {
        if (this.logPrefix == null) {
            this.logPrefix = String.format("Metadata Resolver %s %s:", ((Object)((Object)this)).getClass().getSimpleName(), this.getId());
        }
        return this.logPrefix;
    }

    @Nullable
    public MetadataType resolveSingle(CriteriaSet criteria) throws ResolverException {
        Iterator<MetadataType> iterator;
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        Iterable<MetadataType> iterable = this.resolve(criteria);
        if (iterable != null && (iterator = iterable.iterator()) != null && iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    @Nonnull
    public Iterable<MetadataType> resolve(@Nonnull CriteriaSet criteria) throws ResolverException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        try {
            List metadata = this.getCache().get(criteria);
            return this.predicateFilterCandidates(metadata, criteria, false);
        }
        catch (MetadataCacheException e) {
            throw new ResolverException((Exception)((Object)e));
        }
    }

    protected Iterable<MetadataType> predicateFilterCandidates(@Nonnull Iterable<MetadataType> candidates, @Nonnull CriteriaSet criteria, boolean onEmptyPredicatesReturnEmpty) throws ResolverException {
        boolean satisfyAny;
        if (!candidates.iterator().hasNext()) {
            this.log.debug("{} Candidates iteration was empty, nothing to filter via predicates", (Object)this.getLogPrefix());
            return Collections.emptySet();
        }
        this.log.debug("{} Attempting to filter candidate metadata via resolved Predicates", (Object)this.getLogPrefix());
        Set predicates = ResolverSupport.getPredicates((CriteriaSet)criteria, AbstractEvaluableMetadataCriterion.class, this.getCriterionPredicateRegistry());
        this.log.trace("{} Resolved {} Predicates: {}", new Object[]{this.getLogPrefix(), predicates.size(), predicates});
        SatisfyAnyCriterion satisfyAnyCriterion = (SatisfyAnyCriterion)criteria.get(SatisfyAnyCriterion.class);
        if (satisfyAnyCriterion != null) {
            this.log.trace("{} CriteriaSet contained SatisfyAnyCriterion", (Object)this.getLogPrefix());
            satisfyAny = satisfyAnyCriterion.isSatisfyAny();
        } else {
            this.log.trace("{} CriteriaSet did NOT contain SatisfyAnyCriterion", (Object)this.getLogPrefix());
            satisfyAny = this.isSatisfyAnyPredicates();
        }
        this.log.trace("{} Effective satisyAny value: {}", (Object)this.getLogPrefix(), (Object)satisfyAny);
        Iterable result = ResolverSupport.getFilteredIterable(candidates, (Set)predicates, (boolean)satisfyAny, (boolean)onEmptyPredicatesReturnEmpty);
        if (this.log.isDebugEnabled()) {
            this.log.debug("{} After predicate filtering {} Metadata entities remain", (Object)this.getLogPrefix(), (Object)Iterables.size((Iterable)result));
        }
        return result;
    }

    public boolean isSatisfyAnyPredicates() {
        return this.satisfyAnyPredicates;
    }

    public void setSatisfyAnyPredicates(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.satisfyAnyPredicates = flag;
    }

    @NonnullAfterInit
    public CriterionPredicateRegistry<MetadataType> getCriterionPredicateRegistry() {
        return this.criterionPredicateRegistry;
    }

    public void setCriterionPredicateRegistry(@Nullable CriterionPredicateRegistry<MetadataType> registry) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.criterionPredicateRegistry = registry;
    }

    @Nonnull
    protected MetadataCache<MetadataType> getCache() {
        return this.cache;
    }

    public boolean isFailFastInitialization() {
        return this.failFastInitialization;
    }

    public void setFailFastInitialization(boolean failFast) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.failFastInitialization = failFast;
    }

    protected final void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        try {
            this.initMetadataResolver();
        }
        catch (ComponentInitializationException e) {
            if (this.isFailFastInitialization()) {
                this.log.error("{} Metadata provider failed to properly initialize, fail-fast=true, halting", (Object)this.getLogPrefix());
                throw e;
            }
            this.log.error("{} Metadata provider failed to properly initialize, fail-fast=false, continuing on in a degraded state", (Object)this.getLogPrefix(), (Object)e);
        }
    }

    protected void doDestroy() {
        if (this.cache instanceof DestructableComponent) {
            ((DestructableComponent)this.cache).destroy();
        }
    }

    protected abstract void initMetadataResolver() throws ComponentInitializationException;
}

