/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.metadata.impl;

import com.nimbusds.oauth2.sdk.id.Identifier;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.time.Instant;
import java.util.Timer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.metadata.impl.AbstractReloadingOIDCEntityResolver;
import net.shibboleth.oidc.metadata.impl.ResolverHelper;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public abstract class AbstractFileOIDCEntityResolver<Key extends Identifier, Value>
extends AbstractReloadingOIDCEntityResolver<Key, Value> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractFileOIDCEntityResolver.class);
    @Nonnull
    private File metadataFile;

    public AbstractFileOIDCEntityResolver(@Nonnull Resource metadata) throws IOException {
        this.setMetadataFile(metadata.getFile());
    }

    public AbstractFileOIDCEntityResolver(@Nullable Timer backgroundTaskTimer, @Nonnull Resource metadata) throws IOException {
        super(backgroundTaskTimer);
        this.setMetadataFile(metadata.getFile());
    }

    protected void setMetadataFile(@Nonnull File file) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.metadataFile = (File)Constraint.isNotNull((Object)file, (String)"Metadata file cannot be null");
    }

    protected void doDestroy() {
        this.metadataFile = null;
        super.doDestroy();
    }

    @Override
    protected String getMetadataIdentifier() {
        return this.metadataFile.getAbsolutePath();
    }

    protected Instant getMetadataUpdateTime() {
        return Instant.ofEpochMilli(this.metadataFile.lastModified());
    }

    @Override
    protected byte[] fetchMetadata() throws ResolverException {
        try {
            ResolverHelper.validateMetadataFile(this.metadataFile);
            Instant metadataUpdateTime = this.getMetadataUpdateTime();
            if (this.getLastRefresh() == null || this.getLastUpdate() == null || metadataUpdateTime.isAfter(this.getLastRefresh())) {
                this.log.debug("Returning the contents of {} as byte array", (Object)this.metadataFile.toPath());
                return ResolverHelper.inputstreamToByteArray(new FileInputStream(this.metadataFile));
            }
            return null;
        }
        catch (IOException e) {
            String errMsg = "Unable to read metadata file " + this.metadataFile.getAbsolutePath();
            this.log.error(errMsg, (Throwable)e);
            throw new ResolverException(errMsg, (Exception)e);
        }
    }
}

