/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.metadata.impl;

import com.google.common.base.Strings;
import com.google.common.net.MediaType;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.collection.LazySet;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.protocol.HttpContext;
import org.opensaml.security.httpclient.HttpClientSecurityParameters;
import org.opensaml.security.httpclient.HttpClientSecuritySupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public abstract class AbstractDynamicHTTPFetchingStrategy<MetadataType>
extends AbstractIdentifiableInitializableComponent
implements Function<CriteriaSet, MetadataType> {
    public static final String MDC_ATTRIB_CURRENT_REQUEST_URI = AbstractDynamicHTTPFetchingStrategy.class.getName() + ".currentRequestURI";
    private static final String[] DEFAULT_CONTENT_TYPES = new String[]{"application/json", "application/samlmetadata+xml", "application/xml", "text/xml"};
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractDynamicHTTPFetchingStrategy.class);
    @Nonnull
    private final HttpClient httpClient;
    @NonnullAfterInit
    private List<String> supportedContentTypes;
    @NonnullAfterInit
    private String supportedContentTypesValue;
    @NonnullAfterInit
    private Set<MediaType> supportedMediaTypes;
    @Nullable
    private HttpClientSecurityParameters httpClientSecurityParameters;
    @Nonnull
    private final ResponseHandler<MetadataType> responseHandler;

    protected AbstractDynamicHTTPFetchingStrategy(@Nonnull HttpClient client, @Nonnull ResponseHandler<MetadataType> handler) {
        this.responseHandler = (ResponseHandler)Constraint.isNotNull(handler, (String)"Response handler can not be null");
        this.httpClient = (HttpClient)Constraint.isNotNull((Object)client, (String)"HTTP Client can not be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.getSupportedContentTypes() == null) {
            this.setSupportedContentTypes(Arrays.asList(DEFAULT_CONTENT_TYPES));
        }
        if (!this.getSupportedContentTypes().isEmpty()) {
            this.supportedContentTypesValue = StringSupport.listToStringValue(this.getSupportedContentTypes(), (String)", ");
            this.supportedMediaTypes = new LazySet();
            for (String contentType : this.getSupportedContentTypes()) {
                this.supportedMediaTypes.add(MediaType.parse((String)contentType));
            }
        } else {
            this.supportedMediaTypes = Collections.emptySet();
        }
        this.log.debug("{} Supported content types are: {}", (Object)this.getId(), this.getSupportedContentTypes());
    }

    public void setHttpClientSecurityParameters(@Nullable HttpClientSecurityParameters params) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.httpClientSecurityParameters = params;
    }

    @NonnullAfterInit
    @NotLive
    @Unmodifiable
    public List<String> getSupportedContentTypes() {
        return this.supportedContentTypes;
    }

    public void setSupportedContentTypes(@Nullable List<String> types) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.supportedContentTypes = types == null ? Collections.emptyList() : StringSupport.normalizeStringCollection(types).stream().filter(s -> s != null).map(String::toLowerCase).collect(Collectors.toUnmodifiableList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public MetadataType apply(@Nonnull CriteriaSet criteria) {
        this.log.info("{} fetching metadata based on criteria: {}", (Object)this.getId(), (Object)criteria);
        HttpUriRequest request = this.buildHttpRequest(criteria);
        if (request == null) {
            this.log.debug("Could not build request based on input criteria, unable to query");
            return null;
        }
        HttpClientContext context = this.buildHttpClientContext(request);
        try {
            MDC.put((String)MDC_ATTRIB_CURRENT_REQUEST_URI, (String)request.getURI().toString());
            Object result = this.httpClient.execute(request, this.responseHandler, (HttpContext)context);
            HttpClientSecuritySupport.checkTLSCredentialEvaluated((HttpClientContext)context, (String)request.getURI().getScheme());
            Object object = result;
            return (MetadataType)object;
        }
        catch (IOException e) {
            this.log.warn("Unable to fetch metadata from remote HTTP source", (Throwable)e);
            MetadataType MetadataType = null;
            return MetadataType;
        }
        finally {
            MDC.remove((String)MDC_ATTRIB_CURRENT_REQUEST_URI);
        }
    }

    private HttpClientContext buildHttpClientContext(@Nonnull HttpUriRequest request) {
        HttpClientContext context = HttpClientContext.create();
        HttpClientSecuritySupport.marshalSecurityParameters((HttpClientContext)context, (HttpClientSecurityParameters)this.httpClientSecurityParameters, (boolean)true);
        HttpClientSecuritySupport.addDefaultTLSTrustEngineCriteria((HttpClientContext)context, (HttpUriRequest)request);
        return context;
    }

    @Nullable
    private HttpUriRequest buildHttpRequest(@Nonnull CriteriaSet criteria) {
        String url = this.buildRequestURL(criteria);
        this.log.debug("Built request URL of: {}", (Object)url);
        if (url == null) {
            this.log.debug("Could not construct request URL from input criteria, unable to query");
            return null;
        }
        HttpGet getMethod = new HttpGet(url);
        if (!Strings.isNullOrEmpty((String)this.supportedContentTypesValue)) {
            getMethod.addHeader("Accept", this.supportedContentTypesValue);
        }
        return getMethod;
    }

    @Nullable
    protected abstract String buildRequestURL(@Nonnull CriteriaSet var1);
}

