/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.metadata.cache.impl;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.oidc.metadata.cache.MetadataCacheException;
import net.shibboleth.oidc.metadata.cache.impl.AbstractMetadataCache;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class FetchThroughMetadataCache<IdentifierType, MetadataType>
extends AbstractMetadataCache<IdentifierType, MetadataType> {
    private final Logger log = LoggerFactory.getLogger(FetchThroughMetadataCache.class);
    @NonnullAfterInit
    private Function<CriteriaSet, MetadataType> fetchStrategy;

    protected FetchThroughMetadataCache() {
        super(null);
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.fetchStrategy == null) {
            throw new ComponentInitializationException("Metadata fetching strategy can not be null");
        }
    }

    public void setFetchStrategy(@Nonnull Function<CriteriaSet, MetadataType> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.fetchStrategy = (Function)Constraint.isNotNull(strategy, (String)"Dynamic Metadata fetch strategy can not be null");
    }

    @Nonnull
    @NonnullElements
    @NotLive
    public List<MetadataType> get(@Nonnull @NotEmpty CriteriaSet criteria) throws MetadataCacheException {
        if (!this.isInitialized()) {
            throw new MetadataCacheException("Metadata cache has not been initialized");
        }
        Object identifier = this.getCriteriaToIdentifierStrategy().apply(criteria);
        this.log.debug("{} Resolved criteria to identifier: {}", (Object)this.getLogPrefix(), identifier);
        if (identifier != null) {
            MetadataType resolvedMetadata = this.fetchStrategy.apply(criteria);
            if (resolvedMetadata != null && this.getMetadataValidPredicate().test(resolvedMetadata)) {
                Object filteredMetadata = this.getMetadataFilterStrategy().apply(resolvedMetadata, this.newFilterContext());
                if (filteredMetadata == null) {
                    this.log.warn("{} Filtered metadata is null, no further processing performed", (Object)this.getLogPrefix());
                    return Collections.emptyList();
                }
                Object extractedIdentifier = this.getIdentifierExtractionStrategy().apply(filteredMetadata);
                if (extractedIdentifier == null) {
                    this.log.warn("{} Metadata identifier could not be extracted, no further processing performed", (Object)this.getLogPrefix());
                    return Collections.emptyList();
                }
                if (!Objects.equals(identifier, extractedIdentifier)) {
                    this.log.warn("{} New metadata's identifer '{}' does not match expected identifier '{}', will not process", new Object[]{this.getLogPrefix(), extractedIdentifier, identifier});
                    return Collections.emptyList();
                }
                this.log.debug("{} Resolved metadata with identifier '{}'", (Object)this.getLogPrefix(), extractedIdentifier);
                return List.of(filteredMetadata);
            }
            this.log.trace("{} Metadata for '{}' could not be resolved or is not valid", (Object)this.getLogPrefix(), identifier);
        } else {
            this.log.debug("Identifier not resolvable from criteria, can not fetch metadata");
        }
        return Collections.emptyList();
    }
}

