/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.metadata.cache.impl;

import java.time.Duration;
import java.time.Instant;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.logic.Constraint;

public class DefaultSourceMetadataExpirationTimeStrategy
implements Function<byte[], Instant> {
    @Nonnull
    private final Duration expiryDuration;

    public DefaultSourceMetadataExpirationTimeStrategy(@Nonnull Duration duration) {
        this.expiryDuration = (Duration)Constraint.isNotNull((Object)duration, (String)"Expiry duration can not be null");
    }

    @Override
    public Instant apply(@Nullable byte[] sourceMetadata) {
        return Instant.now().plus(this.expiryDuration);
    }
}

