/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.metadata.cache.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.time.Instant;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.oidc.metadata.cache.CacheLoadingContext;
import net.shibboleth.oidc.metadata.cache.CacheLoadingException;
import net.shibboleth.oidc.metadata.cache.LoadingStrategy;
import net.shibboleth.oidc.metadata.impl.ResolverHelper;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

@ThreadSafe
public class DefaultFileLoadingStrategy
implements LoadingStrategy {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DefaultFileLoadingStrategy.class);
    @Nullable
    private final File metadataFile;
    @Nonnull
    @NotEmpty
    private final String metadataFileFriendlyName;

    public DefaultFileLoadingStrategy(@Nullable Resource metadata) throws IOException {
        if (metadata == null) {
            this.log.warn("File resource is null, no bytes will be returned");
            this.metadataFile = null;
            this.metadataFileFriendlyName = "No file specified";
        } else {
            this.metadataFile = metadata.getFile();
            this.metadataFileFriendlyName = metadata.getDescription();
        }
    }

    private Instant getMetadataUpdateTime() {
        return Instant.ofEpochMilli(this.metadataFile.lastModified());
    }

    @Nullable
    public byte[] load(@Nonnull CacheLoadingContext context) throws CacheLoadingException {
        if (this.metadataFile == null) {
            return null;
        }
        try {
            ResolverHelper.validateMetadataFile(this.metadataFile);
            Instant metadataUpdateTime = this.getMetadataUpdateTime();
            if (context.getLastRefresh() == null || context.getLastUpdate() == null || metadataUpdateTime.isAfter(context.getLastRefresh())) {
                this.log.debug("Returning the contents of {} as byte array", (Object)this.metadataFile.toPath());
                return ResolverHelper.inputstreamToByteArray(new FileInputStream(this.metadataFile));
            }
            return null;
        }
        catch (Exception e) {
            String errMsg = "Unable to read metadata file " + this.metadataFile.getAbsolutePath();
            this.log.error(errMsg, (Object)e.getMessage());
            throw new CacheLoadingException(errMsg, e);
        }
    }

    @Nonnull
    public String getSourceIdentifier() {
        return this.metadataFileFriendlyName;
    }
}

