/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.metadata.cache.impl;

import com.google.common.base.Predicates;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.metadata.cache.LoadingStrategy;
import net.shibboleth.oidc.metadata.cache.impl.BaseMetadataCacheBuilderSpec;
import net.shibboleth.oidc.metadata.cache.impl.MetadataCacheBuilderSpec;
import net.shibboleth.utilities.java.support.annotation.constraint.Positive;
import net.shibboleth.utilities.java.support.logic.Constraint;

public class BatchMetadataCacheBuilderSpec<IdentifierType, MetadataType>
extends BaseMetadataCacheBuilderSpec<IdentifierType, MetadataType>
implements MetadataCacheBuilderSpec<IdentifierType, MetadataType> {
    @Nullable
    private Function<byte[], List<MetadataType>> parsingStrategy;
    @Nullable
    private LoadingStrategy loadingStrategy;
    @Nonnull
    @Positive
    private Duration maxRefreshDelay = Duration.ofHours(4L);
    @Nonnull
    @Positive
    private Duration minRefreshDelay = Duration.ofMinutes(5L);
    @Nonnull
    private boolean matchOnIdentifierRequired = false;
    @Nullable
    private Function<byte[], Instant> sourceMetadataExpiryStrategy;
    @Nonnull
    private Predicate<byte[]> sourceMetadataValidPredicate = Predicates.alwaysTrue();

    public void setSourceMetadataValidPredicate(@Nonnull Predicate<byte[]> predicate) {
        this.sourceMetadataValidPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"Is source metadata valid predicate can not be null");
    }

    @Nonnull
    protected Predicate<byte[]> getSourceMetadataValidPredicate() {
        return this.sourceMetadataValidPredicate;
    }

    public void setSourceMetadataExpiryStrategy(@Nonnull Function<byte[], Instant> strategy) {
        this.sourceMetadataExpiryStrategy = (Function)Constraint.isNotNull(strategy, (String)"Source metadata expiry strategy can not be null");
    }

    @Nullable
    protected Function<byte[], Instant> getSourceMetadataExpiryStrategy() {
        return this.sourceMetadataExpiryStrategy;
    }

    public void setMatchRequired(boolean required) {
        this.matchOnIdentifierRequired = required;
    }

    public boolean isMatchOnIdentifierRequired() {
        return this.matchOnIdentifierRequired;
    }

    @Nonnull
    protected Duration getMinRefreshDelay() {
        return this.minRefreshDelay;
    }

    @Nonnull
    protected Duration getMaxRefreshDelay() {
        return this.maxRefreshDelay;
    }

    public void setMinRefreshDelay(@Nonnull @Positive Duration delay) {
        Constraint.isFalse((delay == null || delay.isNegative() ? 1 : 0) != 0, (String)"Minimum refresh delay must be greater than 0");
        this.minRefreshDelay = delay;
    }

    public void setMaxRefreshDelay(@Nonnull @Positive Duration delay) {
        Constraint.isFalse((delay == null || delay.isNegative() ? 1 : 0) != 0, (String)"Maximum refresh delay must be greater than 0");
        this.maxRefreshDelay = delay;
    }

    public void setParsingStrategy(@Nonnull Function<byte[], List<MetadataType>> strategy) {
        this.parsingStrategy = (Function)Constraint.isNotNull(strategy, (String)"Parsing strategy can not be null");
    }

    @Nullable
    protected Function<byte[], List<MetadataType>> getParsingStrategy() {
        return this.parsingStrategy;
    }

    public void setLoadingStrategy(@Nonnull LoadingStrategy strategy) {
        this.loadingStrategy = (LoadingStrategy)Constraint.isNotNull((Object)strategy, (String)"Batch metadata loading strategy can not be null");
    }

    @Nullable
    protected LoadingStrategy getLoadingStrategy() {
        return this.loadingStrategy;
    }
}

