/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.metadata.cache.impl;

import com.google.common.base.Predicates;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.metadata.filter.MetadataFilterContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.Positive;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;

public abstract class BaseMetadataCacheBuilderSpec<IdentifierType, MetadataType> {
    @Positive
    private Float refreshDelayFactor = Float.valueOf(0.75f);
    @Nullable
    private Function<MetadataType, IdentifierType> identifierExtractionStrategy;
    @Nullable
    private Function<CriteriaSet, IdentifierType> criteriaToIdentifierStrategy;
    @Nonnull
    private BiFunction<MetadataType, MetadataFilterContext, MetadataType> metadataFilterStrategy = (metadata, context) -> metadata;
    @Nonnull
    private String cacheId = "Unknown";
    @Nullable
    private BiConsumer<List<MetadataType>, IdentifierType> metadataBeforeRemovalHook;
    @Nonnull
    private Predicate<MetadataType> metadataValidPredicate = Predicates.alwaysTrue();

    protected BaseMetadataCacheBuilderSpec() {
    }

    public void setMetadataValidPredicate(@Nonnull Predicate<MetadataType> predicate) {
        this.metadataValidPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"Is metadata valid predicate can not be null");
    }

    @Nonnull
    protected Predicate<MetadataType> getMetadataValidPredicate() {
        return this.metadataValidPredicate;
    }

    public void setCacheId(@Nonnull @NotEmpty String id) {
        this.cacheId = Constraint.isNotEmpty((String)id, (String)"Cache identifier can not be null or empty");
    }

    @Nonnull
    protected String getCacheId() {
        return this.cacheId;
    }

    public void setMetadataBeforeRemovalHook(@Nullable BiConsumer<List<MetadataType>, IdentifierType> hook) {
        this.metadataBeforeRemovalHook = hook;
    }

    @Nullable
    protected BiConsumer<List<MetadataType>, IdentifierType> getMetadataBeforeRemovalHook() {
        return this.metadataBeforeRemovalHook;
    }

    public void setMetadataFilterStrategy(@Nonnull BiFunction<MetadataType, MetadataFilterContext, MetadataType> strategy) {
        this.metadataFilterStrategy = (BiFunction)Constraint.isNotNull(strategy, (String)"Metadata filtering strategy can not be null");
    }

    @Nonnull
    protected BiFunction<MetadataType, MetadataFilterContext, MetadataType> getMetadataFilterStrategy() {
        return this.metadataFilterStrategy;
    }

    public void setIdentifierExtractionStrategy(@Nonnull Function<MetadataType, IdentifierType> strategy) {
        this.identifierExtractionStrategy = (Function)Constraint.isNotNull(strategy, (String)"Strategy can not be null");
    }

    @Nullable
    protected Function<MetadataType, IdentifierType> getIdentifierExtractionStrategy() {
        return this.identifierExtractionStrategy;
    }

    public void setCriteriaToIdentifierStrategy(@Nonnull Function<CriteriaSet, IdentifierType> strategy) {
        this.criteriaToIdentifierStrategy = (Function)Constraint.isNotNull(strategy, (String)"Criteria to identifier strategy can not be null");
    }

    @Nullable
    protected Function<CriteriaSet, IdentifierType> getCriteriaToIdentifierStrategy() {
        return this.criteriaToIdentifierStrategy;
    }

    @Nonnull
    protected Float getRefreshDelayFactor() {
        return this.refreshDelayFactor;
    }

    public void setRefreshDelayFactor(@Nonnull Float factor) {
        if (factor.floatValue() <= 0.0f || factor.floatValue() >= 1.0f) {
            throw new ConstraintViolationException("Refresh delay factor must be a number between 0.0 and 1.0, exclusive");
        }
        this.refreshDelayFactor = factor;
    }
}

