/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.metadata.cache.impl;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.metadata.BackingStore;
import net.shibboleth.oidc.metadata.MetadataManagementData;
import net.shibboleth.oidc.metadata.cache.MetadataCache;
import net.shibboleth.oidc.metadata.cache.MetadataCacheException;
import net.shibboleth.oidc.metadata.filter.MetadataFilterContext;
import net.shibboleth.oidc.metadata.filter.MetadataSource;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.Positive;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import net.shibboleth.utilities.java.support.primitive.TimerSupport;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMetadataCache<IdentifierType, MetadataType>
extends AbstractIdentifiableInitializableComponent
implements MetadataCache<MetadataType> {
    private final Logger log = LoggerFactory.getLogger(AbstractMetadataCache.class);
    @Nullable
    private String logPrefix;
    @NonnullAfterInit
    @Positive
    private Float refreshDelayFactor;
    @Nullable
    private final BackingStore<IdentifierType, MetadataType> backingStore;
    @Nullable
    private BiConsumer<List<MetadataType>, IdentifierType> metadataBeforeRemovalHook;
    @NonnullAfterInit
    private Function<MetadataType, IdentifierType> identifierExtractionStrategy;
    @NonnullAfterInit
    private Function<CriteriaSet, IdentifierType> criteriaToIdentifierStrategy;
    @NonnullAfterInit
    private BiFunction<MetadataType, MetadataFilterContext, MetadataType> metadataFilterStrategy;
    @NonnullAfterInit
    private Predicate<MetadataType> metadataValidPredicate;
    @NonnullAfterInit
    private ScheduledExecutorService executorService;
    private boolean createOwnSchedular;

    AbstractMetadataCache(@Nullable BackingStore<IdentifierType, MetadataType> store) {
        this(store, null);
    }

    AbstractMetadataCache(@Nullable BackingStore<IdentifierType, MetadataType> store, @Nullable ScheduledExecutorService executor) {
        this.backingStore = store;
        if (executor != null) {
            this.executorService = executor;
            this.createOwnSchedular = false;
        } else {
            this.createOwnSchedular = true;
        }
    }

    @Nonnull
    @NotEmpty
    protected String getLogPrefix() {
        if (this.logPrefix == null) {
            this.logPrefix = "Metadata Cache " + (this.getId() != null ? this.getId() : "(unknown)") + ":";
        }
        return this.logPrefix;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.identifierExtractionStrategy == null) {
            throw new ComponentInitializationException("Identifier extraction strategy can not be null");
        }
        if (this.criteriaToIdentifierStrategy == null) {
            throw new ComponentInitializationException("Criteria to identifier strategy can not be null");
        }
        if (this.metadataFilterStrategy == null) {
            throw new ComponentInitializationException("Metadata filter strategy can not be null");
        }
        if (this.refreshDelayFactor == null) {
            throw new ComponentInitializationException("Metadata cache not property initialized");
        }
        if (this.metadataValidPredicate == null) {
            throw new ComponentInitializationException("Metadata validation predicate can not be null");
        }
        if (this.createOwnSchedular) {
            this.executorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat(TimerSupport.getTimerName((Object)((Object)this)) + "-%d").build());
        }
    }

    protected void doDestroy() {
        this.executorService.shutdown();
        super.doDestroy();
    }

    @NonnullAfterInit
    protected ScheduledExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setMetadataValidPredicate(@Nonnull Predicate<MetadataType> predicate) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.metadataValidPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"Is metadata valid predicate can not be null");
    }

    @Nonnull
    protected Predicate<MetadataType> getMetadataValidPredicate() {
        return this.metadataValidPredicate;
    }

    public void setCriteriaToIdentifierStrategy(@Nonnull Function<CriteriaSet, IdentifierType> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.criteriaToIdentifierStrategy = (Function)Constraint.isNotNull(strategy, (String)"Criteria to identifier strategy can not be null");
    }

    @NonnullAfterInit
    protected Function<CriteriaSet, IdentifierType> getCriteriaToIdentifierStrategy() {
        return this.criteriaToIdentifierStrategy;
    }

    public void setIdentifierExtractionStrategy(@Nonnull Function<MetadataType, IdentifierType> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.identifierExtractionStrategy = (Function)Constraint.isNotNull(strategy, (String)"Identifier extraction strategy can not be null");
    }

    @NonnullAfterInit
    protected Function<MetadataType, IdentifierType> getIdentifierExtractionStrategy() {
        return this.identifierExtractionStrategy;
    }

    public void setMetadataFilterStrategy(@Nonnull BiFunction<MetadataType, MetadataFilterContext, MetadataType> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.metadataFilterStrategy = (BiFunction)Constraint.isNotNull(strategy, (String)"Metadata filter strategy can not be null");
    }

    @NonnullAfterInit
    protected BiFunction<MetadataType, MetadataFilterContext, MetadataType> getMetadataFilterStrategy() {
        return this.metadataFilterStrategy;
    }

    public void setMetadataBeforeRemovalHook(@Nullable BiConsumer<List<MetadataType>, IdentifierType> hook) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.metadataBeforeRemovalHook = hook;
    }

    public void setRefreshDelayFactor(@Nonnull Float factor) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        if (factor.floatValue() <= 0.0f || factor.floatValue() >= 1.0f) {
            throw new ConstraintViolationException("Refresh delay factor must be a number between 0.0 and 1.0, exclusive");
        }
        this.refreshDelayFactor = factor;
    }

    @NonnullAfterInit
    protected Float getRefreshDelayFactor() {
        return this.refreshDelayFactor;
    }

    @Nonnull
    @NonnullElements
    protected List<MetadataType> lookupIdentifier(@Nonnull @NotEmpty IdentifierType identifier) throws MetadataCacheException {
        if (!this.isInitialized()) {
            throw new MetadataCacheException("Metadata resolver has not been initialized");
        }
        List<MetadataType> metadata = this.lookupIndexedIdentifier(identifier);
        if (metadata.isEmpty()) {
            this.log.debug("{} Metadata cache does not contain an entry for '{}'", (Object)this.getLogPrefix(), identifier);
            return metadata;
        }
        Iterator<MetadataType> metadataIter = metadata.iterator();
        while (metadataIter.hasNext()) {
            MetadataType individualMetadata = metadataIter.next();
            if (this.metadataValidPredicate.test(individualMetadata)) continue;
            this.log.warn("{} Metadata cache contained an entry with the identifier '{}',  but it was no longer valid", (Object)this.getLogPrefix(), identifier);
            metadataIter.remove();
        }
        if (!metadata.isEmpty()) {
            this.log.trace("{} Metadata cache has found '{}' entry(s) for '{}'", new Object[]{this.getLogPrefix(), metadata.size(), identifier});
        }
        return metadata;
    }

    @Nonnull
    @NonnullElements
    protected List<MetadataType> lookupIndexedIdentifier(@Nonnull IdentifierType identifier) {
        List metadata = (List)this.getBackingStore().getIndexedValues().get(identifier);
        if (metadata != null) {
            return new ArrayList(metadata);
        }
        return Collections.emptyList();
    }

    @Nullable
    protected BackingStore<IdentifierType, MetadataType> getBackingStore() {
        return this.backingStore;
    }

    protected void freshLoad(@Nonnull List<MetadataType> metadataToStore) {
        this.invalidateAll();
        for (MetadataType metadata : metadataToStore) {
            this.writeToBackingStore(metadata);
        }
    }

    protected void writeToBackingStore(@Nonnull MetadataType metadata) {
        IdentifierType extractedIdentifier = this.getIdentifierExtractionStrategy().apply(metadata);
        if (extractedIdentifier == null) {
            this.log.warn("{} Identifier could not be extracted from metadata, metadata not stored", (Object)this.getLogPrefix());
            return;
        }
        this.invalidate(extractedIdentifier);
        this.backingStore.getOrderedValues().add(metadata);
        ArrayList<MetadataType> existingMetadata = (ArrayList<MetadataType>)this.backingStore.getIndexedValues().get(extractedIdentifier);
        if (existingMetadata == null) {
            existingMetadata = new ArrayList<MetadataType>();
            this.backingStore.getIndexedValues().put(extractedIdentifier, existingMetadata);
        } else if (!existingMetadata.isEmpty()) {
            this.log.warn("{} Detected duplicate metadata for identifier: {}", (Object)this.getLogPrefix(), extractedIdentifier);
        }
        existingMetadata.add(metadata);
    }

    @Nonnull
    protected MetadataFilterContext newFilterContext() {
        MetadataSource source = new MetadataSource();
        source.setSourceId(this.getId());
        MetadataFilterContext context = new MetadataFilterContext();
        context.add((Object)source);
        return context;
    }

    protected boolean shouldAttemptRefresh(@Nonnull MetadataManagementData<IdentifierType> mgmtData) {
        return Instant.now().isAfter(mgmtData.getRefreshTriggerTime());
    }

    protected boolean hasExpired(@Nonnull MetadataManagementData<IdentifierType> mgmtData) {
        return Instant.now().isAfter(mgmtData.getExpirationTime());
    }

    protected void invalidate(@Nonnull IdentifierType identifier) {
        Map indexedDescriptors = this.backingStore.getIndexedValues();
        List descriptors = (List)indexedDescriptors.get(identifier);
        if (descriptors != null) {
            if (this.metadataBeforeRemovalHook != null) {
                this.metadataBeforeRemovalHook.accept(descriptors, identifier);
            }
            this.backingStore.getOrderedValues().removeAll(descriptors);
            indexedDescriptors.remove(identifier);
        }
    }

    protected void invalidateAll() {
        this.backingStore.getIndexedValues().clear();
        this.backingStore.getOrderedValues().clear();
    }

    @Nonnull
    protected Runnable errorHandlingWrapper(@Nonnull Runnable action) {
        return () -> {
            try {
                action.run();
            }
            catch (Throwable e) {
                this.log.error("{} Error executing thread task", (Object)this.getLogPrefix(), (Object)e);
            }
        };
    }
}

