/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.metadata.policy.impl;

import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import net.shibboleth.oidc.metadata.cache.LoadingStrategy;
import net.shibboleth.oidc.metadata.cache.MetadataCache;
import net.shibboleth.oidc.metadata.cache.impl.BatchMetadataCache;
import net.shibboleth.oidc.metadata.cache.impl.BatchMetadataCacheBuilderSpec;
import net.shibboleth.oidc.metadata.cache.impl.DefaultFileLoadingStrategy;
import net.shibboleth.oidc.metadata.cache.impl.DefaultJSONMapParsingStrategy;
import net.shibboleth.oidc.metadata.cache.impl.DefaultSourceMetadataExpirationTimeStrategy;
import net.shibboleth.oidc.metadata.cache.impl.MetadataCacheBuilder;
import net.shibboleth.oidc.metadata.cache.impl.MetadataCacheBuilderSpec;
import net.shibboleth.oidc.metadata.policy.MetadataPolicy;
import net.shibboleth.oidc.metadata.policy.impl.DefaultMetadataPolicyValidator;
import net.shibboleth.oidc.metadata.policy.impl.OIDCMetadataPolicyResolver;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.testng.Assert;
import org.testng.annotations.Test;

public class OIDCMetadataPolicyResolverTest {
    OIDCMetadataPolicyResolver resolver;

    public void initTest(String filename) throws Exception {
        this.resolver = new OIDCMetadataPolicyResolver(this.buildCache(filename));
        this.resolver.setId("mockId");
        this.resolver.initialize();
    }

    protected BatchMetadataCache<String, Map<String, MetadataPolicy>> buildCache(String filename) throws IOException, ComponentInitializationException {
        ClassPathResource file = filename == null || filename.isEmpty() ? null : new ClassPathResource(filename);
        BatchMetadataCacheBuilderSpec spec = new BatchMetadataCacheBuilderSpec();
        MetadataCacheBuilder.Builder builder = new MetadataCacheBuilder.Builder();
        spec.setLoadingStrategy((LoadingStrategy)new DefaultFileLoadingStrategy((Resource)file));
        spec.setParsingStrategy((Function)new DefaultJSONMapParsingStrategy(MetadataPolicy.class));
        spec.setMinRefreshDelay(Duration.ofMinutes(5L));
        spec.setMaxRefreshDelay(Duration.ofMinutes(10L));
        spec.setSourceMetadataExpiryStrategy((Function)new DefaultSourceMetadataExpirationTimeStrategy(Duration.ofMinutes(5L)));
        spec.setCriteriaToIdentifierStrategy(crit -> "id");
        spec.setIdentifierExtractionStrategy(crit -> "id");
        spec.setMetadataValidPredicate((Predicate)new DefaultMetadataPolicyValidator());
        spec.setMatchRequired(true);
        spec.setRefreshDelayFactor(Float.valueOf(0.75f));
        spec.setMetadataFilterStrategy((metadata, context) -> metadata);
        MetadataCache cache = builder.build((MetadataCacheBuilderSpec)spec);
        if (!(cache instanceof BatchMetadataCache)) {
            throw new ComponentInitializationException("Wrong cache type");
        }
        return (BatchMetadataCache)cache;
    }

    @Test
    public void testNoPolicyFile() throws Exception {
        this.initTest("");
        Iterator iter = this.resolver.resolve(new CriteriaSet()).iterator();
        Assert.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testInvalidPolicy() throws Exception {
        this.initTest("/net/shibboleth/oidc/metadata/impl/metadata-policy-invalid.json");
        Iterator iter = this.resolver.resolve(new CriteriaSet()).iterator();
        Assert.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testFound() throws Exception {
        this.initTest("/net/shibboleth/oidc/metadata/impl/metadata-policy1.json");
        Iterator iter = this.resolver.resolve(new CriteriaSet()).iterator();
        Assert.assertTrue((boolean)iter.hasNext());
        Map client = (Map)iter.next();
        Assert.assertEquals((int)client.size(), (int)6);
        MetadataPolicy grantTypes = (MetadataPolicy)client.get("grant_types");
        Assert.assertNotNull((Object)grantTypes);
        Assert.assertEquals((Collection)grantTypes.getOneOfValues(), List.of("authorization_code", "implicit"));
        Assert.assertNull((Object)grantTypes.getAdd());
        Assert.assertNull((Object)grantTypes.getDefaultValue());
        Assert.assertNull((Object)grantTypes.getValue());
        Assert.assertFalse((boolean)grantTypes.isEssential());
        Assert.assertNull((Object)grantTypes.getRegexp());
        Assert.assertNull((Object)grantTypes.getSubsetOfValues());
        Assert.assertNull((Object)grantTypes.getSupersetOfValues());
        MetadataPolicy clientName = (MetadataPolicy)client.get("client_name");
        Assert.assertNotNull((Object)clientName);
        Assert.assertNull((Object)clientName.getAdd());
        Assert.assertEquals((Object)clientName.getDefaultValue(), (Object)"A known test application");
        Assert.assertNull((Object)clientName.getValue());
        Assert.assertFalse((boolean)clientName.isEssential());
        Assert.assertNull((Object)clientName.getOneOfValues());
        Assert.assertNull((Object)clientName.getRegexp());
        Assert.assertNull((Object)clientName.getSubsetOfValues());
        Assert.assertNull((Object)clientName.getSupersetOfValues());
        MetadataPolicy organizationName = (MetadataPolicy)client.get("organization_name");
        Assert.assertNotNull((Object)organizationName);
        Assert.assertNull((Object)organizationName.getAdd());
        Assert.assertNull((Object)organizationName.getDefaultValue());
        Assert.assertEquals((Object)organizationName.getValue(), (Object)"A trusted organization");
        Assert.assertFalse((boolean)organizationName.isEssential());
        Assert.assertNull((Object)organizationName.getOneOfValues());
        Assert.assertNull((Object)organizationName.getRegexp());
        Assert.assertNull((Object)organizationName.getSubsetOfValues());
        Assert.assertNull((Object)organizationName.getSupersetOfValues());
        MetadataPolicy redirectUris = (MetadataPolicy)client.get("redirect_uris");
        Assert.assertNotNull((Object)redirectUris);
        Assert.assertNull((Object)redirectUris.getAdd());
        Assert.assertNull((Object)redirectUris.getDefaultValue());
        Assert.assertNull((Object)redirectUris.getValue());
        Assert.assertTrue((boolean)redirectUris.isEssential());
        Assert.assertNull((Object)redirectUris.getOneOfValues());
        Assert.assertEquals((String)redirectUris.getRegexp(), (String)"^https:\\/\\/(?:([^.]+).)?example.org\\/(.*)");
        Assert.assertNull((Object)redirectUris.getSubsetOfValues());
        Assert.assertNull((Object)redirectUris.getSupersetOfValues());
        MetadataPolicy algValuesSupported = (MetadataPolicy)client.get("id_token_signing_alg_values_supported");
        Assert.assertNotNull((Object)algValuesSupported);
        Assert.assertNull((Object)algValuesSupported.getAdd());
        Assert.assertNull((Object)algValuesSupported.getDefaultValue());
        Assert.assertNull((Object)algValuesSupported.getValue());
        Assert.assertFalse((boolean)algValuesSupported.isEssential());
        Assert.assertNull((Object)algValuesSupported.getOneOfValues());
        Assert.assertNull((Object)algValuesSupported.getRegexp());
        Assert.assertEquals((Collection)algValuesSupported.getSubsetOfValues(), List.of("RS256", "RS384", "RS512"));
        Assert.assertNull((Object)algValuesSupported.getSupersetOfValues());
        MetadataPolicy scopes = (MetadataPolicy)client.get("scopes");
        Assert.assertNotNull((Object)scopes);
        Assert.assertNull((Object)scopes.getAdd());
        Assert.assertNull((Object)scopes.getDefaultValue());
        Assert.assertNull((Object)scopes.getValue());
        Assert.assertFalse((boolean)scopes.isEssential());
        Assert.assertNull((Object)scopes.getOneOfValues());
        Assert.assertNull((Object)scopes.getRegexp());
        Assert.assertEquals((Collection)scopes.getSubsetOfValues(), List.of("openid", "profile", "email", "phone"));
        Assert.assertNull((Object)scopes.getSupersetOfValues());
    }
}

