/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.metadata.impl;

import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import java.time.Instant;
import java.util.Date;
import net.shibboleth.oidc.metadata.ClientInformationManagerException;
import net.shibboleth.oidc.metadata.criterion.ClientIDCriterion;
import net.shibboleth.oidc.metadata.impl.StorageServiceClientInformationManager;
import net.shibboleth.oidc.metadata.impl.StorageServiceClientInformationResolver;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.opensaml.storage.StorageService;
import org.opensaml.storage.impl.MemoryStorageService;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class StorageServiceClientInformationManagerTest {
    StorageServiceClientInformationManager manager;
    StorageServiceClientInformationResolver resolver;
    MemoryStorageService storageService;
    String clientIdValue;

    @BeforeMethod
    public void setupTests() throws Exception {
        this.storageService = new MemoryStorageService();
        this.storageService.setId("mockId");
        this.storageService.initialize();
        this.manager = new StorageServiceClientInformationManager();
        this.manager.setStorageService((StorageService)this.storageService);
        this.manager.setId("mockId");
        this.manager.initialize();
        this.resolver = new StorageServiceClientInformationResolver();
        this.resolver.setStorageService((StorageService)this.storageService);
        this.resolver.setId("mockId");
        this.resolver.initialize();
        this.clientIdValue = "mockClientId";
    }

    @Test
    public void testStore() throws Exception {
        OIDCClientInformation clientInformation = this.initializeInformation();
        this.manager.storeClientInformation(clientInformation, null, false);
        try {
            this.manager.storeClientInformation(clientInformation, null, false);
            Assert.fail((String)"Expected ClientInformationManagerException");
        }
        catch (ClientInformationManagerException clientInformationManagerException) {
            // empty catch block
        }
        this.manager.storeClientInformation(clientInformation, null, true);
        CriteriaSet criteria = this.initializeCriteria();
        OIDCClientInformation result = this.resolver.resolveSingle(criteria);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((String)result.getID().getValue(), (String)this.clientIdValue);
    }

    @Test
    public void testNullDestroy() throws Exception {
        OIDCClientInformation clientInformation = this.initializeInformation();
        this.manager.storeClientInformation(clientInformation, null, false);
        this.manager.destroyClientInformation(null);
        CriteriaSet criteria = this.initializeCriteria();
        OIDCClientInformation result = this.resolver.resolveSingle(criteria);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((String)result.getID().getValue(), (String)this.clientIdValue);
    }

    @Test
    public void testDestroy() throws Exception {
        OIDCClientInformation clientInformation = this.initializeInformation();
        this.manager.storeClientInformation(clientInformation, null, false);
        this.manager.destroyClientInformation(new ClientID(this.clientIdValue));
        CriteriaSet criteria = this.initializeCriteria();
        OIDCClientInformation result = this.resolver.resolveSingle(criteria);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testExpiration() throws Exception {
        OIDCClientInformation clientInformation = this.initializeInformation();
        this.manager.storeClientInformation(clientInformation, Instant.now().plusSeconds(2L), false);
        CriteriaSet criteria = this.initializeCriteria();
        OIDCClientInformation result = this.resolver.resolveSingle(criteria);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((String)result.getID().getValue(), (String)this.clientIdValue);
        Thread.sleep(2100L);
        OIDCClientInformation delayedResult = this.resolver.resolveSingle(criteria);
        Assert.assertNull((Object)delayedResult);
    }

    protected OIDCClientInformation initializeInformation() {
        ClientID clientId = new ClientID(this.clientIdValue);
        OIDCClientMetadata metadata = new OIDCClientMetadata();
        return new OIDCClientInformation(clientId, new Date(), metadata, null);
    }

    protected CriteriaSet initializeCriteria() {
        CriteriaSet criteria = new CriteriaSet();
        criteria.add((Object)new ClientIDCriterion(new ClientID(this.clientIdValue)));
        return criteria;
    }
}

