/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.metadata.impl;

import com.unboundid.ldap.listener.InMemoryDirectoryServer;
import com.unboundid.ldap.listener.InMemoryDirectoryServerConfig;
import com.unboundid.ldap.listener.InMemoryListenerConfig;
import com.unboundid.ldap.sdk.LDAPException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.sql.DataSource;
import net.shibboleth.ext.spring.config.IdentifiableBeanPostProcessor;
import net.shibboleth.ext.spring.config.StringToDurationConverter;
import net.shibboleth.ext.spring.util.SchemaTypeAwareXMLBeanDefinitionReader;
import net.shibboleth.idp.attribute.resolver.AttributeResolver;
import net.shibboleth.idp.testing.DatabaseTestingSupport;
import net.shibboleth.oidc.metadata.impl.BaseClientSecretValueResolverTest;
import net.shibboleth.oidc.metadata.impl.ResolverServiceClientSecretValueResolver;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.UnmodifiableComponentException;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import net.shibboleth.utilities.java.support.service.ReloadableService;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.support.ConversionServiceFactoryBean;
import org.springframework.context.support.GenericApplicationContext;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class ResolverServiceClientSecretValueResolverTest
extends BaseClientSecretValueResolverTest<ResolverServiceClientSecretValueResolver> {
    private InMemoryDirectoryServer directoryServer;
    private static final String LDAP_INIT_FILE = "src/test/resources/net/shibboleth/oidc/metadata/impl/ldapDataConnectorTest.ldif";
    private static final String DB_INIT_FILE = "/net/shibboleth/oidc/metadata/impl/RdbmsStore.sql";
    private static final String DB_DATA_FILE = "/net/shibboleth/oidc/metadata/impl/RdbmsData.sql";
    private static final String SERVICE_CONF_FILE = "/net/shibboleth/oidc/metadata/impl/service.xml";
    private GenericApplicationContext pendingTeardownContext = null;
    String entityId = "CLIENT_ID_ONE";
    String entityId2 = "CLIENT_ID_TWO";
    String clientSecretKeyReferenceBoth = "keyReferenceOne";
    String clientSecretKeyReferenceOnlyLdap = "keyReferenceTwo";
    String clientSecretValueRdbms = "thePlainTextSecretValue1234567890";
    String clientSecretValueLdap = "thePlainTextSecretValue9876543210";

    @AfterMethod
    public void tearDownTestContext() {
        if (null == this.pendingTeardownContext) {
            return;
        }
        this.pendingTeardownContext.close();
        this.pendingTeardownContext = null;
    }

    protected void setTestContext(GenericApplicationContext context) {
        this.tearDownTestContext();
        this.pendingTeardownContext = context;
    }

    @BeforeTest
    public void setupDataConnectors() throws LDAPException {
        System.setProperty("org.ldaptive.provider", "org.ldaptive.provider.unboundid.UnboundIDProvider");
        InMemoryDirectoryServerConfig config = new InMemoryDirectoryServerConfig(new String[]{"dc=shibboleth,dc=net"});
        config.setListenerConfigs(new InMemoryListenerConfig[]{InMemoryListenerConfig.createLDAPConfig((String)"default", (int)10391)});
        config.addAdditionalBindCredentials("cn=Directory Manager", "password");
        this.directoryServer = new InMemoryDirectoryServer(config);
        this.directoryServer.importFromLDIF(true, LDAP_INIT_FILE);
        this.directoryServer.startListening();
        DataSource datasource = DatabaseTestingSupport.GetMockDataSource((String)DB_INIT_FILE, (String)"myTestDB");
        DatabaseTestingSupport.InitializeDataSourceFromFile((String)DB_DATA_FILE, (DataSource)datasource);
    }

    @AfterTest
    public void teardownDataConnectors() {
        this.directoryServer.shutDown(true);
        System.clearProperty("org.ldaptive.provider");
    }

    protected ReloadableService<AttributeResolver> getResolver() {
        GenericApplicationContext context = new GenericApplicationContext();
        context.getBeanFactory().addBeanPostProcessor((BeanPostProcessor)new IdentifiableBeanPostProcessor());
        this.setTestContext(context);
        context.setDisplayName("ApplicationContext: " + ResolverServiceClientSecretValueResolverTest.class);
        ConversionServiceFactoryBean service = new ConversionServiceFactoryBean();
        context.setDisplayName("ApplicationContext: ");
        service.setConverters(new HashSet<StringToDurationConverter>(Arrays.asList(new StringToDurationConverter())));
        service.afterPropertiesSet();
        context.getBeanFactory().setConversionService(service.getObject());
        SchemaTypeAwareXMLBeanDefinitionReader beanDefinitionReader = new SchemaTypeAwareXMLBeanDefinitionReader((BeanDefinitionRegistry)context);
        beanDefinitionReader.loadBeanDefinitions(SERVICE_CONF_FILE);
        context.refresh();
        return (ReloadableService)context.getBean(ReloadableService.class);
    }

    @Test(expectedExceptions={ComponentInitializationException.class})
    public void initialize_shouldThrowWhenAttributeResolverNotSet() throws ComponentInitializationException {
        this.resolver = new ResolverServiceClientSecretValueResolver();
        ((ResolverServiceClientSecretValueResolver)this.resolver).setId("mockId");
        ((ResolverServiceClientSecretValueResolver)this.resolver).initialize();
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void setAttributeResolver_shouldThrowIfAttributeResolverIsNull() {
        this.resolver = new ResolverServiceClientSecretValueResolver();
        ((ResolverServiceClientSecretValueResolver)this.resolver).setAttributeResolver(null);
    }

    @Test(expectedExceptions={UnmodifiableComponentException.class})
    public void setAttributeResolver_shouldThrowAfterInit() throws ComponentInitializationException {
        this.resolver = this.buildResolver(true);
        ((ResolverServiceClientSecretValueResolver)this.resolver).setAttributeResolver(this.getResolver());
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void setAttributeIds_shouldThrowIfAttributeIdsNull() throws ComponentInitializationException {
        this.resolver = new ResolverServiceClientSecretValueResolver();
        ((ResolverServiceClientSecretValueResolver)this.resolver).setAttributeIds(null);
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void setAttributeIds_shouldThrowIfAttributeIdsEmpty() throws ComponentInitializationException {
        this.resolver = new ResolverServiceClientSecretValueResolver();
        ((ResolverServiceClientSecretValueResolver)this.resolver).setAttributeIds(Collections.emptyList());
    }

    @Test(expectedExceptions={UnmodifiableComponentException.class})
    public void setAttributeIds_shouldThrowAfterInit() throws ComponentInitializationException {
        this.resolver = this.buildResolver(true);
        ((ResolverServiceClientSecretValueResolver)this.resolver).setAttributeIds(Arrays.asList("myDBClientSecret", "myLDAPClientSecret"));
    }

    @Test
    public void resolveSingle_shouldReturnNullWhenValuesNotFound() throws ResolverException, ComponentInitializationException {
        this.resolver = this.buildResolver(true);
        Assert.assertNull((Object)((ResolverServiceClientSecretValueResolver)this.resolver).resolveSingle(this.buildCriteriaSet("not_found")));
    }

    @Test
    public void resolveSingle_shouldReturnRdbmsValueWhenFound() throws ResolverException, ComponentInitializationException {
        this.resolver = this.buildResolver(true, Arrays.asList("myDBClientSecret"));
        Assert.assertEquals((String)((ResolverServiceClientSecretValueResolver)this.resolver).resolveSingle(this.buildCriteriaSet(this.clientSecretKeyReferenceBoth, this.entityId)), (String)this.clientSecretValueRdbms);
    }

    @Test
    public void resolveSingle_shouldReturnLdapValueWhenFound() throws ResolverException, ComponentInitializationException {
        this.resolver = this.buildResolver(true, Arrays.asList("myLDAPClientSecret"));
        Assert.assertEquals((String)((ResolverServiceClientSecretValueResolver)this.resolver).resolveSingle(this.buildCriteriaSet(this.clientSecretKeyReferenceBoth, this.entityId)), (String)this.clientSecretValueLdap);
    }

    @Test
    public void resolveSingle_shouldReturnLdapValueWhenOnlyFoundFromLdap() throws ResolverException, ComponentInitializationException {
        this.resolver = this.buildResolver(true, Arrays.asList("myDBClientSecret", "myLDAPClientSecret"));
        Assert.assertEquals((String)((ResolverServiceClientSecretValueResolver)this.resolver).resolveSingle(this.buildCriteriaSet(this.clientSecretKeyReferenceOnlyLdap, this.entityId2)), (String)"thePlainTextSecretValue1111111111");
    }

    @Test
    public void resolve_shouldReturnEmptyIteratorWhenValuesNotFound() throws ResolverException, ComponentInitializationException {
        this.resolver = this.buildResolver(true);
        Iterable iterable = ((ResolverServiceClientSecretValueResolver)this.resolver).resolve(this.buildCriteriaSet("not_found"));
        Assert.assertNotNull((Object)iterable);
        Assert.assertFalse((boolean)iterable.iterator().hasNext());
    }

    @Test
    public void resolve_shouldReturnOneValueIteratorWhenSingleValueFound() throws ResolverException, ComponentInitializationException {
        this.resolver = this.buildResolver(true);
        Iterable iterable = ((ResolverServiceClientSecretValueResolver)this.resolver).resolve(this.buildCriteriaSet(this.clientSecretKeyReferenceOnlyLdap, this.entityId2));
        Assert.assertNotNull((Object)iterable);
        Iterator iterator = iterable.iterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((String)((String)iterator.next()), (String)"thePlainTextSecretValue1111111111");
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void resolve_shouldReturnTwoValueIteratorWhenFoundFromBoth() throws ResolverException, ComponentInitializationException {
        this.resolver = this.buildResolver(true);
        Iterable iterable = ((ResolverServiceClientSecretValueResolver)this.resolver).resolve(this.buildCriteriaSet(this.clientSecretKeyReferenceBoth, this.entityId));
        Assert.assertNotNull((Object)iterable);
        Iterator iterator = iterable.iterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        String firstValue = (String)iterator.next();
        Assert.assertTrue((firstValue.equals(this.clientSecretValueLdap) || firstValue.equals(this.clientSecretValueRdbms) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)iterator.hasNext());
        String secondValue = (String)iterator.next();
        Assert.assertFalse((boolean)firstValue.equals(secondValue));
        Assert.assertTrue((secondValue.equals(this.clientSecretValueLdap) || secondValue.equals(this.clientSecretValueRdbms) ? 1 : 0) != 0);
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Override
    protected ResolverServiceClientSecretValueResolver buildResolver(boolean init) throws ComponentInitializationException {
        return this.buildResolver(init, Arrays.asList("myDBClientSecret", "myLDAPClientSecret"));
    }

    protected ResolverServiceClientSecretValueResolver buildResolver(boolean init, List<String> attributeIds) throws ComponentInitializationException {
        ResolverServiceClientSecretValueResolver resolver = new ResolverServiceClientSecretValueResolver();
        resolver.setAttributeResolver(this.getResolver());
        resolver.setAttributeIds(attributeIds);
        resolver.setId("resolver");
        if (init) {
            resolver.initialize();
        }
        return resolver;
    }

    protected CriteriaSet buildCriteriaSet(String secretReference, String clientId) {
        CriteriaSet criteria = super.buildCriteriaSet(secretReference);
        criteria.add((Object)new EntityIdCriterion(clientId));
        return criteria;
    }
}

