/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.metadata.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Predicates;
import com.nimbusds.oauth2.sdk.id.Issuer;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.shibboleth.oidc.metadata.BatchBackingStore;
import net.shibboleth.oidc.metadata.cache.CacheLoadingContext;
import net.shibboleth.oidc.metadata.cache.LoadingStrategy;
import net.shibboleth.oidc.metadata.cache.impl.BatchMetadataCache;
import net.shibboleth.oidc.metadata.cache.impl.ManuallyTriggeredScheduledExecutorService;
import net.shibboleth.oidc.metadata.criterion.IssuerIDCriterion;
import net.shibboleth.oidc.metadata.impl.DefaultBatchBackingStore;
import net.shibboleth.oidc.metadata.impl.OIDCMapBasedMetadataResolver;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class OIDCMapMetadataResolverTest {
    private final String GOOD_PROVIDER_CONFIGURATION_INFO = "{\n\"issuer\": \"https://example.oidc.op.org\",\n\"authorization_endpoint\": \"https://example.oidc.op.org/o/oauth2/v2/auth\",\n\"device_authorization_endpoint\": \"https://oauth2.googleapis.com/device/code\",\n\"token_endpoint\": \"https://oauth2.googleapis.com/token\",\n\"userinfo_endpoint\": \"https://openidconnect.googleapis.com/v1/userinfo\",\n\"revocation_endpoint\": \"https://oauth2.googleapis.com/revoke\",\n\"jwks_uri\": \"https://www.googleapis.com/oauth2/v3/certs\",\n\"response_types_supported\": [\n\"code\",\n\"token\",\n\"id_token\",\n\"code token\",\n\"code id_token\",\n\"token id_token\",\n\"code token id_token\",\n\"none\"\n],\n\"subject_types_supported\": [\n\"public\"\n],\n\"id_token_signing_alg_values_supported\": [\n\"RS256\"\n],\n\"scopes_supported\": [\n\"openid\",\n\"email\",\n\"profile\"\n],\n\"token_endpoint_auth_methods_supported\": [\n\"client_secret_post\",\n\"client_secret_basic\"\n],\n\"claims_supported\": [\n\"aud\",\n\"email\",\n\"email_verified\",\n\"exp\",\n\"family_name\",\n\"given_name\",\n\"iat\",\n\"iss\",\n\"locale\",\n\"name\",\n\"picture\",\n\"sub\"\n],\n\"code_challenge_methods_supported\": [\n\"plain\",\n\"S256\"\n],\n\"grant_types_supported\": [\n\"authorization_code\",\n\"refresh_token\",\n\"urn:ietf:params:oauth:grant-type:device_code\",\n\"urn:ietf:params:oauth:grant-type:jwt-bearer\"\n]\n}";
    private TestableBatchMetadataCache<String, Map<String, Object>> batchCache;
    private OIDCMapBasedMetadataResolver batchResolver;

    @BeforeMethod
    public void setup() throws Exception {
        LoadingStrategy metadataLoadingStrat = new LoadingStrategy(){

            public byte[] load(CacheLoadingContext t) {
                return "{\n\"issuer\": \"https://example.oidc.op.org\",\n\"authorization_endpoint\": \"https://example.oidc.op.org/o/oauth2/v2/auth\",\n\"device_authorization_endpoint\": \"https://oauth2.googleapis.com/device/code\",\n\"token_endpoint\": \"https://oauth2.googleapis.com/token\",\n\"userinfo_endpoint\": \"https://openidconnect.googleapis.com/v1/userinfo\",\n\"revocation_endpoint\": \"https://oauth2.googleapis.com/revoke\",\n\"jwks_uri\": \"https://www.googleapis.com/oauth2/v3/certs\",\n\"response_types_supported\": [\n\"code\",\n\"token\",\n\"id_token\",\n\"code token\",\n\"code id_token\",\n\"token id_token\",\n\"code token id_token\",\n\"none\"\n],\n\"subject_types_supported\": [\n\"public\"\n],\n\"id_token_signing_alg_values_supported\": [\n\"RS256\"\n],\n\"scopes_supported\": [\n\"openid\",\n\"email\",\n\"profile\"\n],\n\"token_endpoint_auth_methods_supported\": [\n\"client_secret_post\",\n\"client_secret_basic\"\n],\n\"claims_supported\": [\n\"aud\",\n\"email\",\n\"email_verified\",\n\"exp\",\n\"family_name\",\n\"given_name\",\n\"iat\",\n\"iss\",\n\"locale\",\n\"name\",\n\"picture\",\n\"sub\"\n],\n\"code_challenge_methods_supported\": [\n\"plain\",\n\"S256\"\n],\n\"grant_types_supported\": [\n\"authorization_code\",\n\"refresh_token\",\n\"urn:ietf:params:oauth:grant-type:device_code\",\n\"urn:ietf:params:oauth:grant-type:jwt-bearer\"\n]\n}".getBytes();
            }

            public String getSourceIdentifier() {
                return "Mock loading source";
            }
        };
        Function<byte[], List> parsingStrat = in -> {
            try {
                ObjectMapper mapper = new ObjectMapper();
                return List.of((Map)mapper.readValue(new String((byte[])in, "UTF-8"), (TypeReference)new TypeReference<Map<String, Object>>(){}));
            }
            catch (JsonProcessingException | UnsupportedEncodingException e) {
                return null;
            }
        };
        ManuallyTriggeredScheduledExecutorService scheduler = new ManuallyTriggeredScheduledExecutorService();
        this.batchCache = new TestableBatchMetadataCache(new DefaultBatchBackingStore(), scheduler);
        this.batchCache.setParsingStrategy(parsingStrat);
        this.batchCache.setLoadingStrategy(metadataLoadingStrat);
        this.batchCache.setId("MockBatchCache");
        this.batchCache.setIdentifierExtractionStrategy(m -> m.get("issuer").toString());
        this.batchCache.setCriteriaToIdentifierStrategy(crit -> {
            IssuerIDCriterion issuerId = (IssuerIDCriterion)crit.get(IssuerIDCriterion.class);
            if (issuerId != null) {
                return issuerId.getIssuerID().getValue();
            }
            return null;
        });
        this.batchCache.setMetadataFilterStrategy((metadata, context) -> metadata);
        this.batchCache.setRefreshDelayFactor(Float.valueOf(0.75f));
        this.batchCache.setMinRefreshDelay(Duration.ofMillis(1000L));
        this.batchCache.setMaxRefreshDelay(Duration.ofMillis(1000L));
        this.batchCache.setMetadataValidPredicate((Predicate)Predicates.alwaysTrue());
        this.batchCache.setSourceMetadataValidPredicate((Predicate)Predicates.alwaysTrue());
        this.batchCache.setRefreshDelayFactor(Float.valueOf(0.75f));
        this.batchCache.setSourceMetadataExpiryStrategy(b -> Instant.now().plus(Duration.ofMinutes(5L)));
        this.batchCache.initialize();
        this.batchResolver = new OIDCMapBasedMetadataResolver(this.batchCache);
        this.batchResolver.setId("MockMapBatchResolver");
        this.batchResolver.initialize();
    }

    @Test
    void testBatchResolve_Success() throws ResolverException, IOException, ComponentInitializationException {
        this.batchResolver.initialize();
        Iterable found = this.batchResolver.resolve(new CriteriaSet(new Criterion[]{new IssuerIDCriterion(new Issuer("https://example.oidc.op.org"))}));
        Assert.assertNotNull((Object)found);
        Assert.assertTrue((boolean)found.iterator().hasNext());
    }

    class TestableBatchMetadataCache<IdentifierType, MetadataType>
    extends BatchMetadataCache<IdentifierType, MetadataType> {
        TestableBatchMetadataCache(@Nullable BatchBackingStore<IdentifierType, MetadataType> store, ScheduledExecutorService executor) {
            super(store, executor);
        }

        public BatchBackingStore<IdentifierType, MetadataType> getBackingStore() {
            return super.getBackingStore();
        }
    }
}

