/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.metadata.impl;

import com.google.common.io.CharStreams;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import net.shibboleth.oidc.metadata.criterion.IssuerIDCriterion;
import net.shibboleth.oidc.metadata.impl.HTTPProviderConfigurationFetchingStrategy;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.mockito.Mockito;
import org.springframework.core.io.ClassPathResource;
import org.testng.Assert;
import org.testng.annotations.Test;

public class HTTPProviderConfigurationFetchingStrategyTest {
    @Test
    public void testProviderConfigurationLoads_Success() throws Exception {
        HttpClient httpClient = (HttpClient)Mockito.mock(HttpClient.class);
        HttpResponse httpResponse = (HttpResponse)Mockito.mock(HttpResponse.class);
        StatusLine statusLine = (StatusLine)Mockito.mock(StatusLine.class);
        Mockito.when((Object)httpResponse.getStatusLine()).thenReturn((Object)statusLine);
        Mockito.when((Object)statusLine.getStatusCode()).thenReturn((Object)200);
        ClassPathResource metadata = new ClassPathResource("/net/shibboleth/oidc/metadata/impl/openid-configuration.json");
        String metadataAsString = CharStreams.toString((Readable)new InputStreamReader(metadata.getInputStream(), StandardCharsets.UTF_8));
        Mockito.when((Object)httpResponse.getEntity()).thenReturn((Object)new StringEntity(metadataAsString));
        Mockito.when((Object)httpClient.execute((HttpUriRequest)Mockito.any(), (ResponseHandler)Mockito.any(), (HttpContext)Mockito.any())).thenReturn((Object)OIDCProviderMetadata.parse((String)metadataAsString));
        HTTPProviderConfigurationFetchingStrategy strategy = new HTTPProviderConfigurationFetchingStrategy(httpClient, (ResponseHandler)new HTTPProviderConfigurationFetchingStrategy.OIDCProviderMetadataResponseHandler());
        OIDCProviderMetadata fetchedMetadata = (OIDCProviderMetadata)strategy.apply(new CriteriaSet(new Criterion[]{new IssuerIDCriterion(new Issuer("https://op.example.com"))}));
        Assert.assertNotNull((Object)fetchedMetadata);
        Assert.assertEquals((String)fetchedMetadata.getIssuer().getValue(), (String)"https://op.example.com");
    }

    @Test
    public void testResponseHandler_Success() throws Exception {
        HTTPProviderConfigurationFetchingStrategy.OIDCProviderMetadataResponseHandler responseHandler = new HTTPProviderConfigurationFetchingStrategy.OIDCProviderMetadataResponseHandler();
        HttpResponse httpResponse = (HttpResponse)Mockito.mock(HttpResponse.class);
        StatusLine statusLine = (StatusLine)Mockito.mock(StatusLine.class);
        Mockito.when((Object)httpResponse.getStatusLine()).thenReturn((Object)statusLine);
        Mockito.when((Object)statusLine.getStatusCode()).thenReturn((Object)200);
        ClassPathResource metadata = new ClassPathResource("/net/shibboleth/oidc/metadata/impl/openid-configuration.json");
        String metadataAsString = CharStreams.toString((Readable)new InputStreamReader(metadata.getInputStream(), StandardCharsets.UTF_8));
        StringEntity StringEntity2 = new StringEntity(metadataAsString);
        StringEntity2.setContentType((Header)new BasicHeader("Content-Type", "application/json"));
        Mockito.when((Object)httpResponse.getEntity()).thenReturn((Object)StringEntity2);
        OIDCProviderMetadata handledMetadata = responseHandler.handleResponse(httpResponse);
        Assert.assertNotNull((Object)handledMetadata);
        Assert.assertEquals((String)handledMetadata.getIssuer().getValue(), (String)"https://op.example.com");
    }

    @Test
    public void testResponseHandler_304Response_NoMetadata() throws Exception {
        HTTPProviderConfigurationFetchingStrategy.OIDCProviderMetadataResponseHandler responseHandler = new HTTPProviderConfigurationFetchingStrategy.OIDCProviderMetadataResponseHandler();
        HttpResponse httpResponse = (HttpResponse)Mockito.mock(HttpResponse.class);
        StatusLine statusLine = (StatusLine)Mockito.mock(StatusLine.class);
        Mockito.when((Object)httpResponse.getStatusLine()).thenReturn((Object)statusLine);
        Mockito.when((Object)statusLine.getStatusCode()).thenReturn((Object)304);
        OIDCProviderMetadata handledMetadata = responseHandler.handleResponse(httpResponse);
        Assert.assertNull((Object)handledMetadata);
    }

    @Test
    public void testResponseHandler_500Response_NoMetadata() throws Exception {
        HTTPProviderConfigurationFetchingStrategy.OIDCProviderMetadataResponseHandler responseHandler = new HTTPProviderConfigurationFetchingStrategy.OIDCProviderMetadataResponseHandler();
        HttpResponse httpResponse = (HttpResponse)Mockito.mock(HttpResponse.class);
        StatusLine statusLine = (StatusLine)Mockito.mock(StatusLine.class);
        Mockito.when((Object)httpResponse.getStatusLine()).thenReturn((Object)statusLine);
        Mockito.when((Object)statusLine.getStatusCode()).thenReturn((Object)500);
        OIDCProviderMetadata handledMetadata = responseHandler.handleResponse(httpResponse);
        Assert.assertNull((Object)handledMetadata);
    }

    @Test
    public void testResponseHandlerWrongContentType_NoMetadata() throws Exception {
        HTTPProviderConfigurationFetchingStrategy.OIDCProviderMetadataResponseHandler responseHandler = new HTTPProviderConfigurationFetchingStrategy.OIDCProviderMetadataResponseHandler();
        HttpResponse httpResponse = (HttpResponse)Mockito.mock(HttpResponse.class);
        StatusLine statusLine = (StatusLine)Mockito.mock(StatusLine.class);
        Mockito.when((Object)httpResponse.getStatusLine()).thenReturn((Object)statusLine);
        Mockito.when((Object)statusLine.getStatusCode()).thenReturn((Object)200);
        ClassPathResource metadata = new ClassPathResource("/net/shibboleth/oidc/metadata/impl/openid-configuration.json");
        String metadataAsString = CharStreams.toString((Readable)new InputStreamReader(metadata.getInputStream(), StandardCharsets.UTF_8));
        StringEntity StringEntity2 = new StringEntity(metadataAsString);
        StringEntity2.setContentType((Header)new BasicHeader("Content-Type", "application/xml"));
        Mockito.when((Object)httpResponse.getEntity()).thenReturn((Object)StringEntity2);
        OIDCProviderMetadata handledMetadata = responseHandler.handleResponse(httpResponse);
        Assert.assertNull((Object)handledMetadata);
    }

    @Test
    public void testResponseHandlerEmptyEntity_NoMetadata() throws Exception {
        HTTPProviderConfigurationFetchingStrategy.OIDCProviderMetadataResponseHandler responseHandler = new HTTPProviderConfigurationFetchingStrategy.OIDCProviderMetadataResponseHandler();
        HttpResponse httpResponse = (HttpResponse)Mockito.mock(HttpResponse.class);
        StatusLine statusLine = (StatusLine)Mockito.mock(StatusLine.class);
        Mockito.when((Object)httpResponse.getStatusLine()).thenReturn((Object)statusLine);
        Mockito.when((Object)statusLine.getStatusCode()).thenReturn((Object)200);
        StringEntity StringEntity2 = new StringEntity("");
        StringEntity2.setContentType((Header)new BasicHeader("Content-Type", "application/json"));
        Mockito.when((Object)httpResponse.getEntity()).thenReturn((Object)StringEntity2);
        OIDCProviderMetadata handledMetadata = responseHandler.handleResponse(httpResponse);
        Assert.assertNull((Object)handledMetadata);
    }
}

