/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.metadata.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import net.shibboleth.oidc.metadata.cache.CacheLoadingContext;
import net.shibboleth.oidc.metadata.cache.CacheLoadingException;
import net.shibboleth.oidc.metadata.cache.impl.DefaultFileLoadingStrategy;
import org.mockito.Mockito;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DefaultFileLoadingStrategyTest {
    private static final String EXAMPLE_FILE_CONTENT = "test";

    @Test
    public void testFileLoads() throws Exception {
        ClassPathResource resource = new ClassPathResource("/net/shibboleth/oidc/metadata/impl/file-loading-strategy-test.txt");
        DefaultFileLoadingStrategy strategy = new DefaultFileLoadingStrategy((Resource)resource);
        byte[] loaded = strategy.load(new CacheLoadingContext(null, null));
        Assert.assertEquals((byte[])loaded, (byte[])EXAMPLE_FILE_CONTENT.getBytes(StandardCharsets.UTF_8));
    }

    @Test(expectedExceptions={FileNotFoundException.class})
    public void testFileDoesNotExist() throws IOException {
        ClassPathResource resource = new ClassPathResource("/net/shibboleth/oidc/metadata/impl/no-file.txt");
        DefaultFileLoadingStrategy strategy = new DefaultFileLoadingStrategy((Resource)resource);
    }

    @Test
    public void testNullFile_NullResponse() throws Exception {
        DefaultFileLoadingStrategy strategy = new DefaultFileLoadingStrategy(null);
        byte[] loaded = strategy.load(new CacheLoadingContext(null, null));
        Assert.assertNull((Object)loaded);
    }

    @Test
    public void testNullResponse_FileNotUpdatedSinceLastLoad() throws Exception {
        ClassPathResource resource = new ClassPathResource("/net/shibboleth/oidc/metadata/impl/file-loading-strategy-test.txt");
        DefaultFileLoadingStrategy strategy = new DefaultFileLoadingStrategy((Resource)resource);
        byte[] loaded = strategy.load(new CacheLoadingContext(Instant.MAX, Instant.MAX));
        Assert.assertNull((Object)loaded);
    }

    @Test(expectedExceptions={CacheLoadingException.class})
    public void testIOErrorOnRead() throws Exception {
        Resource mockResource = (Resource)Mockito.mock(Resource.class);
        Mockito.when((Object)mockResource.getDescription()).thenReturn((Object)new String("mock source"));
        File mockFile = (File)Mockito.mock(File.class);
        Mockito.when((Object)mockResource.getFile()).thenReturn((Object)mockFile);
        Mockito.when((Object)mockFile.exists()).thenReturn((Object)true);
        Mockito.when((Object)mockFile.isFile()).thenReturn((Object)true);
        Mockito.when((Object)mockFile.canRead()).thenReturn((Object)true);
        Mockito.when((Object)mockFile.getPath()).thenReturn((Object)"no path");
        DefaultFileLoadingStrategy strategy = new DefaultFileLoadingStrategy(mockResource);
        byte[] loaded = strategy.load(new CacheLoadingContext(null, null));
    }
}

