/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.metadata.impl;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import com.nimbusds.openid.connect.sdk.SubjectType;
import com.nimbusds.openid.connect.sdk.claims.ACR;
import com.nimbusds.openid.connect.sdk.rp.ApplicationType;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.shibboleth.ext.spring.resource.ResourceHelper;
import net.shibboleth.oidc.metadata.impl.ClientInformationNodeProcessor;
import net.shibboleth.oidc.metadata.keyinfo.ext.impl.provider.ClientSecretProvider;
import net.shibboleth.oidc.metadata.keyinfo.ext.impl.provider.InlineJwksProvider;
import net.shibboleth.oidc.metadata.keyinfo.ext.impl.provider.JWKSReferenceProvider;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import net.shibboleth.utilities.java.support.resource.Resource;
import net.shibboleth.utilities.java.support.xml.ClasspathResolver;
import net.shibboleth.utilities.java.support.xml.SchemaBuilder;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.saml.common.xml.SAMLSchemaBuilder;
import org.opensaml.saml.criterion.EntityRoleCriterion;
import org.opensaml.saml.criterion.ProtocolCriterion;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilter;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilterChain;
import org.opensaml.saml.metadata.resolver.filter.impl.NodeProcessingMetadataFilter;
import org.opensaml.saml.metadata.resolver.filter.impl.SchemaValidationFilter;
import org.opensaml.saml.metadata.resolver.impl.FilesystemMetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.PredicateRoleDescriptorResolver;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.xmlsec.keyinfo.impl.provider.DSAKeyValueProvider;
import org.opensaml.xmlsec.keyinfo.impl.provider.InlineX509DataProvider;
import org.opensaml.xmlsec.keyinfo.impl.provider.RSAKeyValueProvider;
import org.springframework.core.io.ClassPathResource;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.ls.LSResourceResolver;

public class ClientInformationNodeProcessorTest
extends XMLObjectBaseTestCase {
    protected RoleDescriptor parseRoleDescriptor(String mdFileName) throws ResolverException, ComponentInitializationException, URISyntaxException, IOException {
        URL mdURL = ClientInformationNodeProcessorTest.class.getResource(mdFileName);
        File mdFile = new File(mdURL.toURI());
        FilesystemMetadataResolver mdProvider = new FilesystemMetadataResolver(mdFile);
        mdProvider.setParserPool(parserPool);
        mdProvider.setId("test");
        MetadataFilterChain filterChain = new MetadataFilterChain();
        NodeProcessingMetadataFilter filter = new NodeProcessingMetadataFilter();
        ArrayList<Object> providers = new ArrayList<Object>();
        providers.add(new DSAKeyValueProvider());
        providers.add(new RSAKeyValueProvider());
        providers.add(new InlineX509DataProvider());
        providers.add(new InlineJwksProvider());
        providers.add(new JWKSReferenceProvider());
        providers.add(new ClientSecretProvider());
        ArrayList<ClientInformationNodeProcessor> processors = new ArrayList<ClientInformationNodeProcessor>();
        processors.add(new ClientInformationNodeProcessor(providers));
        filter.setNodeProcessors(processors);
        filter.initialize();
        filterChain.getFilters().add(this.buildSchemaValidationFilter());
        filterChain.getFilters().add(filter);
        mdProvider.setMetadataFilter((MetadataFilter)filterChain);
        mdProvider.initialize();
        PredicateRoleDescriptorResolver roleResolver = new PredicateRoleDescriptorResolver((MetadataResolver)mdProvider);
        roleResolver.initialize();
        return roleResolver.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion("mockSamlClientId"), new EntityRoleCriterion(SPSSODescriptor.DEFAULT_ELEMENT_NAME), new ProtocolCriterion("http://openid.net/specs/openid-connect-core-1_0.html")}));
    }

    protected SchemaValidationFilter buildSchemaValidationFilter() {
        SAMLSchemaBuilder samlSchemaBuilder = new SAMLSchemaBuilder(SAMLSchemaBuilder.SAML1Version.SAML_11);
        SchemaBuilder schemaBuilder = new SchemaBuilder();
        schemaBuilder.setResourceResolver((LSResourceResolver)new ClasspathResolver());
        ArrayList<Resource> schemaResources = new ArrayList<Resource>();
        schemaResources.add(ResourceHelper.of((org.springframework.core.io.Resource)new ClassPathResource("/schema/xmldsig-core-schema.xsd")));
        schemaResources.add(ResourceHelper.of((org.springframework.core.io.Resource)new ClassPathResource("/schema/shibboleth-metadata-1.0.xsd")));
        schemaResources.add(ResourceHelper.of((org.springframework.core.io.Resource)new ClassPathResource("/schema/saml-metadata-ext-oidcmd.xsd")));
        schemaBuilder.setSchemaResources(schemaResources);
        samlSchemaBuilder.setSchemaBuilder(schemaBuilder);
        return new SchemaValidationFilter(samlSchemaBuilder);
    }

    @Test
    public void testParsedXMLMetadataWithURI() throws Exception {
        RoleDescriptor role = this.parseRoleDescriptor("/net/shibboleth/oidc/metadata/impl/EntitiesDescriptor-with-oidcmd.xml");
        this.validate(role, false);
    }

    @Test
    public void testParsedXMLMetadataWithData() throws Exception {
        RoleDescriptor role = this.parseRoleDescriptor("/net/shibboleth/oidc/metadata/impl/EntitiesDescriptor-with-oidcmd-jwkdata.xml");
        this.validate(role, true);
    }

    private void validate(RoleDescriptor role, boolean jwkdata) throws Exception {
        Assert.assertNotNull((Object)role);
        Assert.assertTrue((boolean)(role instanceof SPSSODescriptor));
        SPSSODescriptor sp = (SPSSODescriptor)role;
        List clientInformations = sp.getObjectMetadata().get(OIDCClientInformation.class);
        Assert.assertNotNull((Object)clientInformations);
        Assert.assertEquals((int)clientInformations.size(), (int)1);
        OIDCClientInformation clientInformation = (OIDCClientInformation)clientInformations.get(0);
        Assert.assertEquals((String)clientInformation.getID().getValue(), (String)"mockSamlClientId");
        OIDCClientMetadata metadata = clientInformation.getOIDCMetadata();
        Assert.assertEquals((Object)metadata.getApplicationType(), (Object)ApplicationType.WEB);
        Assert.assertEquals((Object)metadata.getURI(), (Object)new URI("https://example.org/clientUri"));
        List defaultAcrs = metadata.getDefaultACRs();
        Assert.assertEquals((int)defaultAcrs.size(), (int)2);
        Assert.assertTrue((boolean)defaultAcrs.contains(new ACR("password")));
        Assert.assertTrue((boolean)defaultAcrs.contains(new ACR("mfa")));
        Set grantTypes = metadata.getGrantTypes();
        Assert.assertEquals((int)grantTypes.size(), (int)1);
        Assert.assertEquals(grantTypes.iterator().next(), (Object)GrantType.AUTHORIZATION_CODE);
        Assert.assertEquals((Object)metadata.getIDTokenJWEAlg(), (Object)JWEAlgorithm.A256KW);
        Assert.assertEquals((Object)metadata.getIDTokenJWEEnc(), (Object)EncryptionMethod.A256GCM);
        Assert.assertEquals((Object)metadata.getIDTokenJWSAlg(), (Object)JWSAlgorithm.RS512);
        Assert.assertEquals((Object)metadata.getInitiateLoginURI(), (Object)new URI("https://example.org/initiateLogin"));
        Set postLogoutUris = metadata.getPostLogoutRedirectionURIs();
        Assert.assertEquals((int)postLogoutUris.size(), (int)1);
        Assert.assertEquals(postLogoutUris.iterator().next(), (Object)new URI("https://example.org/postLogout"));
        Assert.assertEquals((Object)metadata.getRequestObjectJWEAlg(), (Object)JWEAlgorithm.A128KW);
        Assert.assertEquals((Object)metadata.getRequestObjectJWEEnc(), (Object)EncryptionMethod.A128GCM);
        Assert.assertEquals((Object)metadata.getRequestObjectJWSAlg(), (Object)JWSAlgorithm.RS256);
        Set requestUris = metadata.getRequestObjectURIs();
        Assert.assertEquals((int)requestUris.size(), (int)1);
        Assert.assertEquals(requestUris.iterator().next(), (Object)new URI("https://example.org/request"));
        Set responseTypes = metadata.getResponseTypes();
        Assert.assertEquals((int)responseTypes.size(), (int)4);
        Assert.assertTrue((boolean)responseTypes.contains(ResponseType.parse((String)"code")));
        Assert.assertTrue((boolean)responseTypes.contains(ResponseType.parse((String)"code id_token")));
        Assert.assertTrue((boolean)responseTypes.contains(ResponseType.parse((String)"id_token token")));
        Assert.assertTrue((boolean)responseTypes.contains(ResponseType.parse((String)"id_token")));
        Scope scope = metadata.getScope();
        Assert.assertEquals((int)scope.size(), (int)2);
        Assert.assertTrue((boolean)scope.contains("openid"));
        Assert.assertTrue((boolean)scope.contains("profile"));
        Assert.assertEquals((Object)metadata.getSectorIDURI(), (Object)new URI("https://example.org/sectorIdentifier"));
        Assert.assertEquals((String)metadata.getSoftwareID().getValue(), (String)"mockSoftwareId");
        Assert.assertEquals((String)metadata.getSoftwareVersion().getValue(), (String)"mockSoftwareVersion");
        Assert.assertEquals((Object)metadata.getTokenEndpointAuthMethod(), (Object)ClientAuthenticationMethod.CLIENT_SECRET_BASIC);
        Assert.assertEquals((Object)metadata.getTokenEndpointAuthJWSAlg(), (Object)JWSAlgorithm.RS512);
        Assert.assertEquals((Object)metadata.getUserInfoJWEAlg(), (Object)JWEAlgorithm.A192KW);
        Assert.assertEquals((Object)metadata.getUserInfoJWEEnc(), (Object)EncryptionMethod.A192GCM);
        Assert.assertEquals((Object)metadata.getUserInfoJWSAlg(), (Object)JWSAlgorithm.RS384);
        if (jwkdata) {
            JWKSet jwkSet = metadata.getJWKSet();
            Assert.assertEquals((int)jwkSet.getKeys().size(), (int)4);
            Assert.assertNotNull((Object)jwkSet.getKeyByKeyId("mock"));
            Assert.assertNotNull((Object)jwkSet.getKeyByKeyId("mockRSA"));
            Assert.assertNotNull((Object)jwkSet.getKeyByKeyId("mockX509RSA"));
            Assert.assertNotNull((Object)jwkSet.getKeyByKeyId("mockX509EC"));
            Assert.assertNull((Object)metadata.getJWKSetURI());
        } else {
            Assert.assertNull((Object)metadata.getJWKSet());
            Assert.assertEquals((Object)metadata.getJWKSetURI(), (Object)new URI("https://example.org/jwks"));
        }
        Set redirectUris = metadata.getRedirectionURIs();
        Assert.assertEquals((int)redirectUris.size(), (int)2);
        Assert.assertTrue((boolean)redirectUris.contains(new URI("https://example.org/cb")));
        Assert.assertTrue((boolean)redirectUris.contains(new URI("https://example.org/cb2")));
        Assert.assertEquals((Object)metadata.getSubjectType(), (Object)SubjectType.PAIRWISE);
    }
}

