/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.metadata.impl;

import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import net.shibboleth.oidc.metadata.criterion.IssuerIDCriterion;
import net.shibboleth.oidc.metadata.impl.ChainingProviderMetadataResolver;
import net.shibboleth.oidc.metadata.impl.FilesystemProviderMetadataResolver;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ChainingProviderMetadataResolverTest {
    @Nonnull
    private ChainingProviderMetadataResolver resolver;

    @BeforeMethod
    public void setup() throws ResolverException, IOException, ComponentInitializationException {
        this.resolver = new ChainingProviderMetadataResolver();
        this.resolver.setId("mockChainResolver");
        FilesystemProviderMetadataResolver provider = new FilesystemProviderMetadataResolver((Resource)new ClassPathResource("/net/shibboleth/oidc/metadata/impl/openid-configuration.json"));
        provider.setId("mockFileProvider");
        provider.initialize();
        this.resolver.setResolvers(List.of(provider));
        this.resolver.initialize();
    }

    @Test
    public void success() throws ResolverException, IOException {
        Issuer issuer = new Issuer("https://op.example.com");
        CriteriaSet set = new CriteriaSet(new Criterion[]{new IssuerIDCriterion(issuer)});
        Iterator metadatas = this.resolver.resolve(set).iterator();
        Assert.assertEquals((String)((OIDCProviderMetadata)metadatas.next()).getIssuer().getValue(), (String)issuer.getValue());
        Assert.assertFalse((boolean)metadatas.hasNext());
    }

    @Test
    public void fail() throws ResolverException, IOException {
        Issuer issuer = new Issuer("no-metadata");
        CriteriaSet set = new CriteriaSet(new Criterion[]{new IssuerIDCriterion(issuer)});
        Iterator metadatas = this.resolver.resolve(set).iterator();
        Assert.assertFalse((boolean)metadatas.hasNext());
    }
}

