/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.metadata.cache.impl;

import com.nimbusds.oauth2.sdk.as.AuthorizationServerMetadata;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.openid.connect.sdk.SubjectType;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import net.shibboleth.oidc.metadata.cache.CacheLoadingContext;
import net.shibboleth.oidc.metadata.cache.LoadingStrategy;
import net.shibboleth.oidc.metadata.cache.MetadataCache;
import net.shibboleth.oidc.metadata.cache.impl.BatchMetadataCache;
import net.shibboleth.oidc.metadata.cache.impl.BatchMetadataCacheBuilderSpec;
import net.shibboleth.oidc.metadata.cache.impl.DynamicMetadataCache;
import net.shibboleth.oidc.metadata.cache.impl.DynamicMetadataCacheBuilderSpec;
import net.shibboleth.oidc.metadata.cache.impl.MetadataCacheBuilder;
import net.shibboleth.oidc.metadata.cache.impl.MetadataCacheBuilderSpec;
import net.shibboleth.oidc.metadata.criterion.IssuerIDCriterion;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.testng.Assert;
import org.testng.annotations.Test;

public class MetadataCacheBuilderTest {
    @Test
    public void testDynamicCacheBuilder_Success() throws ComponentInitializationException {
        MetadataCacheBuilder.Builder builder = new MetadataCacheBuilder.Builder();
        DynamicMetadataCacheBuilderSpec spec = new DynamicMetadataCacheBuilderSpec();
        spec.setIdentifierExtractionStrategy(AuthorizationServerMetadata::getIssuer);
        spec.setMetadataExpirationTimeStrategy(ctx -> ctx.getNow().plus(Duration.ofMinutes(5L)));
        spec.setCriteriaToIdentifierStrategy(crit -> {
            IssuerIDCriterion issuerId = (IssuerIDCriterion)crit.get(IssuerIDCriterion.class);
            if (issuerId != null) {
                return issuerId.getIssuerID();
            }
            return null;
        });
        spec.setCleanupTaskInterval(Duration.ofSeconds(100L));
        spec.setInitialCleanupTaskDelay(Duration.ofSeconds(1L));
        spec.setMaxIdleEntityData(Duration.ofMinutes(10L));
        spec.setRefreshDelayFactor(Float.valueOf(0.75f));
        spec.setMinCacheDuration(Duration.ofMinutes(10L));
        spec.setMetadataFilterStrategy((metadata, context) -> metadata);
        spec.setFetchStrategy(crit -> {
            try {
                Issuer iss = ((IssuerIDCriterion)crit.get(IssuerIDCriterion.class)).getIssuerID();
                return new OIDCProviderMetadata(iss, List.of(SubjectType.PUBLIC), new URI("http://op.example.org/jwk"));
            }
            catch (URISyntaxException e) {
                return null;
            }
        });
        spec.setCacheId("MockDynamicCache");
        MetadataCache cache = builder.build((MetadataCacheBuilderSpec)spec);
        Assert.assertNotNull((Object)cache);
        Assert.assertTrue((boolean)(cache instanceof DynamicMetadataCache));
    }

    @Test
    public void testBatchCacheBuilder_Success() throws ComponentInitializationException {
        MetadataCacheBuilder.Builder builder = new MetadataCacheBuilder.Builder();
        BatchMetadataCacheBuilderSpec spec = new BatchMetadataCacheBuilderSpec();
        spec.setIdentifierExtractionStrategy(AuthorizationServerMetadata::getIssuer);
        spec.setMinRefreshDelay(Duration.ofMinutes(5L));
        spec.setMaxRefreshDelay(Duration.ofMinutes(10L));
        spec.setSourceMetadataExpiryStrategy(b -> Instant.now().plus(Duration.ofMinutes(5L)));
        spec.setCriteriaToIdentifierStrategy(crit -> {
            IssuerIDCriterion issuerId = (IssuerIDCriterion)crit.get(IssuerIDCriterion.class);
            if (issuerId != null) {
                return issuerId.getIssuerID();
            }
            return null;
        });
        spec.setRefreshDelayFactor(Float.valueOf(0.75f));
        spec.setMetadataFilterStrategy((metadata, context) -> metadata);
        spec.setLoadingStrategy(new LoadingStrategy(){

            public byte[] load(CacheLoadingContext t) {
                return "test".getBytes();
            }

            public String getSourceIdentifier() {
                return "Mock loading source";
            }
        });
        spec.setParsingStrategy(bytesIn -> {
            try {
                return List.of(new OIDCProviderMetadata(new Issuer("http://op.example.org"), List.of(SubjectType.PUBLIC), new URI("http://op.example.org/jwk")));
            }
            catch (URISyntaxException e) {
                return Collections.emptyList();
            }
        });
        MetadataCache cache = builder.build((MetadataCacheBuilderSpec)spec);
        Assert.assertNotNull((Object)cache);
        Assert.assertTrue((boolean)(cache instanceof BatchMetadataCache));
    }
}

