/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.metadata.cache.impl;

import com.google.common.base.Predicates;
import com.nimbusds.oauth2.sdk.as.AuthorizationServerMetadata;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.openid.connect.sdk.SubjectType;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.shibboleth.oidc.metadata.DynamicBackingStore;
import net.shibboleth.oidc.metadata.MetadataManagementData;
import net.shibboleth.oidc.metadata.cache.MetadataCacheException;
import net.shibboleth.oidc.metadata.cache.impl.DynamicMetadataCache;
import net.shibboleth.oidc.metadata.cache.impl.ManuallyTriggeredScheduledExecutorService;
import net.shibboleth.oidc.metadata.criterion.IssuerIDCriterion;
import net.shibboleth.oidc.metadata.impl.DefaultDynamicBackingStore;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class DynamicMetadataCacheTest {
    private final Logger log = LoggerFactory.getLogger(DynamicMetadataCacheTest.class);
    private DynamicMetadataCache<Issuer, OIDCProviderMetadata> cache;
    @Nonnull
    private Function<CriteriaSet, OIDCProviderMetadata> defaultFetchStrategy;

    @BeforeMethod
    void setup() throws Exception {
        this.defaultFetchStrategy = crit -> {
            try {
                Issuer iss = ((IssuerIDCriterion)crit.get(IssuerIDCriterion.class)).getIssuerID();
                return new OIDCProviderMetadata(iss, List.of(SubjectType.PUBLIC), new URI("http://example.oidc.op.org"));
            }
            catch (URISyntaxException e) {
                return null;
            }
        };
        ManuallyTriggeredScheduledExecutorService scheduler = new ManuallyTriggeredScheduledExecutorService();
        this.cache = new DynamicMetadataCache((DynamicBackingStore)new DefaultDynamicBackingStore(), (ScheduledExecutorService)scheduler);
        this.cache.setFetchStrategy(this.defaultFetchStrategy);
        this.cache.setIdentifierExtractionStrategy(AuthorizationServerMetadata::getIssuer);
        this.cache.setMetadataExpirationTimeStrategy(ctx -> ctx.getNow().plus(Duration.ofMinutes(5L)));
        this.cache.setCriteriaToIdentifierStrategy(crit -> {
            IssuerIDCriterion issuerId = (IssuerIDCriterion)crit.get(IssuerIDCriterion.class);
            if (issuerId != null) {
                return issuerId.getIssuerID();
            }
            return null;
        });
        this.cache.setCleanupTaskInterval(Duration.ofSeconds(100L));
        this.cache.setInitialCleanupTaskDelay(Duration.ofSeconds(1L));
        this.cache.setMaxIdleEntityData(Duration.ofMinutes(10L));
        this.cache.setRemoveIdleEntityData(true);
        this.cache.setRefreshDelayFactor(Float.valueOf(0.75f));
        this.cache.setMinCacheDuration(Duration.ofMinutes(10L));
        this.cache.setMetadataValidPredicate((Predicate)Predicates.alwaysTrue());
        this.cache.setMaxCacheDuration(Duration.ofMinutes(20L));
        this.cache.setMetadataFilterStrategy((metadata, context) -> metadata);
        this.cache.setId("MockCache");
    }

    @AfterMethod
    public void tearDown() {
        if (this.cache != null) {
            this.cache.destroy();
        }
    }

    @Test
    public void testBackgroundCleanup_Expired_Success() throws ComponentInitializationException, URISyntaxException, InterruptedException {
        ManuallyTriggeredScheduledExecutorService scheduler = new ManuallyTriggeredScheduledExecutorService();
        DynamicMetadataCache cacheLocal = new DynamicMetadataCache((DynamicBackingStore)new DefaultDynamicBackingStore(), (ScheduledExecutorService)scheduler);
        cacheLocal.setFetchStrategy(this.defaultFetchStrategy);
        cacheLocal.setIdentifierExtractionStrategy(AuthorizationServerMetadata::getIssuer);
        cacheLocal.setMetadataExpirationTimeStrategy(ctx -> ctx.getNow().plus(Duration.ofMinutes(10L)));
        cacheLocal.setCriteriaToIdentifierStrategy(crit -> ((IssuerIDCriterion)crit.get(IssuerIDCriterion.class)).getIssuerID());
        cacheLocal.setMetadataBeforeRemovalHook((metadata, identifer) -> this.log.info("Before removal hook ran"));
        cacheLocal.setCleanupTaskInterval(Duration.ofSeconds(20L));
        cacheLocal.setInitialCleanupTaskDelay(Duration.ofSeconds(1L));
        cacheLocal.setMaxIdleEntityData(Duration.ofSeconds(10L));
        cacheLocal.setRemoveIdleEntityData(true);
        cacheLocal.setRefreshDelayFactor(Float.valueOf(0.75f));
        cacheLocal.setMinCacheDuration(Duration.ofMinutes(10L));
        cacheLocal.setMaxCacheDuration(Duration.ofMinutes(20L));
        cacheLocal.setMetadataFilterStrategy((metadata, context) -> metadata);
        cacheLocal.setMetadataValidPredicate((Predicate)Predicates.alwaysTrue());
        cacheLocal.setId("MockCache");
        cacheLocal.initialize();
        Issuer iss = new Issuer("https://example.oidc.op.org");
        MetadataManagementData mgmtData = cacheLocal.getBackingStore().computeManagementDataIfAbsent((Object)iss, MetadataManagementData::new);
        Instant now = Instant.now();
        mgmtData.setLastUpdateTime(now);
        mgmtData.setExpirationTime(now.minus(Duration.ofMinutes(10L)));
        mgmtData.setRefreshTriggerTime(now.plus(Duration.ofMinutes(10L)));
        OIDCProviderMetadata metadata2 = new OIDCProviderMetadata(iss, List.of(SubjectType.PUBLIC), new URI("http://example.oidc.op.org/metadata"));
        cacheLocal.getBackingStore().getOrderedValues().add(metadata2);
        cacheLocal.getBackingStore().getIndexedValues().put(iss, List.of(metadata2));
        Assert.assertFalse((boolean)cacheLocal.getBackingStore().getIndexedValues().isEmpty());
        Assert.assertFalse((boolean)cacheLocal.getBackingStore().getOrderedValues().isEmpty());
        scheduler.triggerScheduledTasks();
        Assert.assertTrue((boolean)cacheLocal.getBackingStore().getIndexedValues().isEmpty());
        Assert.assertTrue((boolean)cacheLocal.getBackingStore().getOrderedValues().isEmpty());
    }

    @Test(expectedExceptions={MetadataCacheException.class})
    public void testCacheNotInitialized() throws Exception {
        DynamicMetadataCache cacheLocal = new DynamicMetadataCache((DynamicBackingStore)new DefaultDynamicBackingStore());
        Issuer iss = new Issuer("https://example.oidc.op.org");
        cacheLocal.get(new CriteriaSet(new Criterion[]{new IssuerIDCriterion(iss)}));
    }

    @Test
    public void testPreExpiredMetadata() throws Exception {
        this.cache.setMetadataExpirationTimeStrategy(ctx -> ctx.getNow().minus(Duration.ofMinutes(5L)));
        this.cache.setMinCacheDuration(Duration.ofSeconds(0L));
        this.cache.initialize();
        Issuer iss = new Issuer("https://example.oidc.op.org");
        List metadata = this.cache.get(new CriteriaSet(new Criterion[]{new IssuerIDCriterion(iss)}));
        Assert.assertEquals((int)metadata.size(), (int)0);
    }

    @Test
    public void testFetchFailsAndCachedIsExpired() throws Exception {
        Issuer iss = new Issuer("https://example.oidc.op.org");
        MetadataManagementData mgmtData = this.cache.getBackingStore().computeManagementDataIfAbsent((Object)iss, MetadataManagementData::new);
        mgmtData.setExpirationTime(Instant.now().minus(Duration.ofSeconds(1L)));
        mgmtData.setRefreshTriggerTime(Instant.now());
        this.cache.getBackingStore().getIndexedValues().put(iss, List.of(new OIDCProviderMetadata(iss, List.of(SubjectType.PUBLIC), new URI("http://example.oidc.op.org/metadata"))));
        this.cache.setMetadataExpirationTimeStrategy(ctx -> ctx.getNow().minus(Duration.ofMinutes(5L)));
        this.cache.setMinCacheDuration(Duration.ofSeconds(0L));
        this.cache.setFetchStrategy(c -> null);
        this.cache.initialize();
        List metadata = this.cache.get(new CriteriaSet(new Criterion[]{new IssuerIDCriterion(iss)}));
        Assert.assertEquals((int)metadata.size(), (int)0);
    }

    @Test(enabled=false)
    public void testBackgroundCleanup_Idle_Success() throws Exception {
        ManuallyTriggeredScheduledExecutorService scheduler = new ManuallyTriggeredScheduledExecutorService();
        DynamicMetadataCache cacheLocal = new DynamicMetadataCache((DynamicBackingStore)new DefaultDynamicBackingStore(), (ScheduledExecutorService)scheduler);
        cacheLocal.setFetchStrategy(this.defaultFetchStrategy);
        cacheLocal.setIdentifierExtractionStrategy(AuthorizationServerMetadata::getIssuer);
        cacheLocal.setMetadataExpirationTimeStrategy(ctx -> ctx.getNow().plus(Duration.ofMinutes(10L)));
        cacheLocal.setCriteriaToIdentifierStrategy(crit -> ((IssuerIDCriterion)crit.get(IssuerIDCriterion.class)).getIssuerID());
        cacheLocal.setCleanupTaskInterval(Duration.ofSeconds(20L));
        cacheLocal.setInitialCleanupTaskDelay(Duration.ofSeconds(1L));
        cacheLocal.setMaxIdleEntityData(Duration.ofMillis(0L));
        cacheLocal.setRemoveIdleEntityData(true);
        cacheLocal.setRefreshDelayFactor(Float.valueOf(0.75f));
        cacheLocal.setMinCacheDuration(Duration.ofMinutes(10L));
        cacheLocal.setMaxCacheDuration(Duration.ofMinutes(20L));
        cacheLocal.setMetadataValidPredicate((Predicate)Predicates.alwaysTrue());
        cacheLocal.setMetadataFilterStrategy((metadata, context) -> metadata);
        cacheLocal.setId("MockCache");
        cacheLocal.initialize();
        Issuer iss = new Issuer("https://example.oidc.op.org");
        MetadataManagementData mgmtData = cacheLocal.getBackingStore().computeManagementDataIfAbsent((Object)iss, MetadataManagementData::new);
        Instant now = Instant.now();
        mgmtData.setLastUpdateTime(now);
        mgmtData.setExpirationTime(now.plus(Duration.ofMinutes(10L)));
        mgmtData.setRefreshTriggerTime(now.plus(Duration.ofMinutes(10L)));
        mgmtData.recordEntityAccess();
        OIDCProviderMetadata metadata2 = new OIDCProviderMetadata(iss, List.of(SubjectType.PUBLIC), new URI("http://example.oidc.op.org/metadata"));
        cacheLocal.getBackingStore().getOrderedValues().add(metadata2);
        cacheLocal.getBackingStore().getIndexedValues().put(iss, List.of(metadata2));
        Assert.assertFalse((boolean)cacheLocal.getBackingStore().getIndexedValues().isEmpty());
        Assert.assertFalse((boolean)cacheLocal.getBackingStore().getOrderedValues().isEmpty());
        scheduler.triggerScheduledTasks();
        Assert.assertTrue((boolean)cacheLocal.getBackingStore().getIndexedValues().isEmpty());
        Assert.assertTrue((boolean)cacheLocal.getBackingStore().getOrderedValues().isEmpty());
    }

    @Test(enabled=true)
    public void testStaleMetadata_Success() throws Exception {
        this.cache.initialize();
        Issuer iss = new Issuer("https://example.oidc.op.org");
        MetadataManagementData mgmtData = this.cache.getBackingStore().computeManagementDataIfAbsent((Object)iss, MetadataManagementData::new);
        Instant now = Instant.now();
        mgmtData.setLastUpdateTime(now);
        mgmtData.setExpirationTime(now.minus(Duration.ofMinutes(10L)));
        mgmtData.setRefreshTriggerTime(now.minus(Duration.ofMinutes(10L)));
        Instant firstUpdateTime = now.minus(Duration.ofSeconds(5L));
        mgmtData.setLastUpdateTime(firstUpdateTime);
        OIDCProviderMetadata metadata = new OIDCProviderMetadata(iss, List.of(SubjectType.PUBLIC), new URI("http://example.oidc.op.org/metadata"));
        this.cache.getBackingStore().getOrderedValues().add(metadata);
        this.cache.getBackingStore().getIndexedValues().put(iss, List.of(metadata));
        Assert.assertFalse((boolean)this.cache.getBackingStore().getIndexedValues().isEmpty());
        Assert.assertFalse((boolean)this.cache.getBackingStore().getOrderedValues().isEmpty());
        this.cache.get(new CriteriaSet(new Criterion[]{new IssuerIDCriterion(iss)}));
        Assert.assertTrue((boolean)mgmtData.getLastUpdateTime().isAfter(firstUpdateTime));
    }

    @Test
    public void testGetNotCached_Success() throws MetadataCacheException, ComponentInitializationException {
        this.cache.initialize();
        List metadata = this.cache.get(new CriteriaSet(new Criterion[]{new IssuerIDCriterion(new Issuer("the-issuer"))}));
        Assert.assertTrue((!metadata.isEmpty() ? 1 : 0) != 0);
    }

    @Test
    public void testGetNotCached_WrongIdentifier_Fail() throws MetadataCacheException, ComponentInitializationException {
        ManuallyTriggeredScheduledExecutorService scheduler = new ManuallyTriggeredScheduledExecutorService();
        DynamicMetadataCache localCache = new DynamicMetadataCache((DynamicBackingStore)new DefaultDynamicBackingStore(), (ScheduledExecutorService)scheduler);
        localCache.setFetchStrategy(crit -> {
            try {
                return new OIDCProviderMetadata(new Issuer("wrong-id"), List.of(SubjectType.PUBLIC), new URI("http://example.oidc.op.org"));
            }
            catch (URISyntaxException e) {
                return null;
            }
        });
        localCache.setIdentifierExtractionStrategy(AuthorizationServerMetadata::getIssuer);
        localCache.setMetadataExpirationTimeStrategy(ctx -> ctx.getNow().plus(Duration.ofMinutes(5L)));
        localCache.setCriteriaToIdentifierStrategy(crit -> {
            IssuerIDCriterion issuerId = (IssuerIDCriterion)crit.get(IssuerIDCriterion.class);
            if (issuerId != null) {
                return issuerId.getIssuerID();
            }
            return null;
        });
        localCache.setCleanupTaskInterval(Duration.ofSeconds(100L));
        localCache.setInitialCleanupTaskDelay(Duration.ofSeconds(1L));
        localCache.setMaxIdleEntityData(Duration.ofMinutes(10L));
        localCache.setRemoveIdleEntityData(true);
        localCache.setRefreshDelayFactor(Float.valueOf(0.75f));
        localCache.setMinCacheDuration(Duration.ofMinutes(10L));
        localCache.setMaxCacheDuration(Duration.ofMinutes(20L));
        localCache.setMetadataValidPredicate((Predicate)Predicates.alwaysTrue());
        localCache.setMetadataFilterStrategy((metadata, context) -> metadata);
        localCache.setId("MockCache");
        localCache.initialize();
        List metadata2 = localCache.get(new CriteriaSet(new Criterion[]{new IssuerIDCriterion(new Issuer("the-issuer"))}));
        Assert.assertTrue((boolean)metadata2.isEmpty());
    }

    @Test
    public void testGetNotCached_WrongCriteria_Fail() throws MetadataCacheException, ComponentInitializationException {
        this.cache.initialize();
        List metadata = this.cache.get(new CriteriaSet(new Criterion[]{new EntityIdCriterion("wrong-criteria")}));
        Assert.assertTrue((boolean)metadata.isEmpty());
    }

    @Test(enabled=true)
    public void testMultiGet_Success() throws InterruptedException, ExecutionException, MetadataCacheException, ComponentInitializationException {
        this.cache.initialize();
        ExecutorService service = Executors.newFixedThreadPool(3);
        Future<List> futureOne = service.submit(() -> this.cache.get(new CriteriaSet(new Criterion[]{new IssuerIDCriterion(new Issuer("the-issuer"))})));
        Future<List> futureTwo = service.submit(() -> this.cache.get(new CriteriaSet(new Criterion[]{new IssuerIDCriterion(new Issuer("the-issuer"))})));
        Future<List> futureThree = service.submit(() -> this.cache.get(new CriteriaSet(new Criterion[]{new IssuerIDCriterion(new Issuer("the-issuer"))})));
        List firstMetadata = futureOne.get();
        List secondMetadata = futureThree.get();
        List thirdMetadata = futureTwo.get();
        List provider = this.cache.get(new CriteriaSet(new Criterion[]{new IssuerIDCriterion(new Issuer("the-issuer"))}));
        Assert.assertTrue((firstMetadata.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((secondMetadata.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((thirdMetadata.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((provider.size() == 1 ? 1 : 0) != 0);
        Assert.assertSame(firstMetadata.get(0), secondMetadata.get(0));
        Assert.assertSame(firstMetadata.get(0), thirdMetadata.get(0));
        Assert.assertSame(firstMetadata.get(0), provider.get(0));
    }

    @Test
    public void testGetCached_Success() throws MetadataCacheException, ComponentInitializationException {
        this.cache.initialize();
        List metadata = this.cache.get(new CriteriaSet(new Criterion[]{new IssuerIDCriterion(new Issuer("the-issuer"))}));
        Assert.assertTrue((metadata.size() == 1 ? 1 : 0) != 0);
        List metadataCached = this.cache.get(new CriteriaSet(new Criterion[]{new IssuerIDCriterion(new Issuer("the-issuer"))}));
        Assert.assertTrue((metadata.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((metadata.get(0) == metadataCached.get(0) ? 1 : 0) != 0);
    }
}

