/*
 * Licensed to the University Corporation for Advanced Internet Development,
 * Inc. (UCAID) under one or more contributor license agreements.  See the
 * NOTICE file distributed with this work for additional information regarding
 * copyright ownership. The UCAID licenses this file to You under the Apache
 * License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.oidc.profile.spring.relyingparty.metadata.filter.impl;

import javax.annotation.Nonnull;
import javax.xml.namespace.QName;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

import net.shibboleth.oidc.metadata.impl.ClientInformationNodeProcessor;
import net.shibboleth.oidc.profile.spring.relyingparty.metadata.impl.MetadataNamespaceHandler;
import net.shibboleth.utilities.java.support.primitive.StringSupport;

/**
 * Parser for a &lt;ClientInformation&gt; node processor.
 */
public class ClientInformationParser extends AbstractSingleBeanDefinitionParser {
    
    /** Element name. */
    @Nonnull public static final QName TYPE_NAME =
            new QName(MetadataNamespaceHandler.NAMESPACE, "ClientInformation");
    
    /** Class logger. */
    @Nonnull private final Logger log = LoggerFactory.getLogger(ClientInformationParser.class);
    
    /** {@inheritDoc} */
    @Override protected Class<?> getBeanClass(final Element element) {
        return ClientInformationNodeProcessor.class;
    }

    /** {@inheritDoc} */
    @Override
    protected void doParse(final Element element, final ParserContext parserContext,
            final BeanDefinitionBuilder builder) {
        super.doParse(element, parserContext, builder);

        if (element.hasAttributeNS(null, "keyInfoProvidersRef")) {
            builder.addConstructorArgReference(StringSupport.trimOrNull(element.getAttributeNS(null,
                    "keyInfoProvidersRef")));
        } else {
            log.error("No 'keyInfoProvidersRef' attribute defined!");
        }
    }

    /** {@inheritDoc} */
    @Override protected boolean shouldGenerateId() {
        return true;
    }
    
}
