/*
 * Licensed to the University Corporation for Advanced Internet Development,
 * Inc. (UCAID) under one or more contributor license agreements.  See the
 * NOTICE file distributed with this work for additional information regarding
 * copyright ownership. The UCAID licenses this file to You under the Apache
 * License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.oidc.metadata.impl;

import java.util.Map;

import javax.annotation.Nonnull;

import net.shibboleth.oidc.metadata.JSONMetadataResolver;
import net.shibboleth.oidc.metadata.cache.MetadataCache;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;

/** Concrete metadata resolver for OIDC Provider configuration metadata resolution.*/
public class JSONMapMetadataResolver 
        extends AbstractOIDCMetadataResolver<String, Map<String, Object>> implements JSONMetadataResolver {

    /**
     * Constructor.
     *
     * @param metadataCache the cache to hold metadata.
     */
    public JSONMapMetadataResolver(
            @Nonnull final MetadataCache<Map<String, Object>> metadataCache) {
        super(metadataCache);
        
    }

    @Override
    protected void initMetadataResolver() throws ComponentInitializationException {
        // Do nothing       
    }

}
