/*
 * Licensed to the University Corporation for Advanced Internet Development,
 * Inc. (UCAID) under one or more contributor license agreements.  See the
 * NOTICE file distributed with this work for additional information regarding
 * copyright ownership. The UCAID licenses this file to You under the Apache
 * License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.oidc.metadata.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;

import net.shibboleth.oidc.metadata.BackingStore;

/**
 * A base backing store implementation.
 *
 * @param <I> The metadata identifier type.
 * @param <T> The metadata type.
 */
@ThreadSafe
public abstract class AbstractBackingStore<I, T> implements BackingStore<I, T> {
    
    /** Index of entity IDs to their descriptors. */
    private Map<I, List<T>> indexedValues;

    /** Ordered list of entity descriptors. */
    private List<T> orderedValues;

    
    /**
     * Constructor.
     */
    AbstractBackingStore() {
        super();
        indexedValues = new ConcurrentHashMap<>();
        orderedValues = new ArrayList<>();               
    }

    @Override
    @Nonnull public Map<I, List<T>> getIndexedValues() {
        return indexedValues;
    }

    @Override
    @Nonnull public List<T> getOrderedValues() {
        return orderedValues;
    }
    
  

}
