/*
 * Licensed to the University Corporation for Advanced Internet Development,
 * Inc. (UCAID) under one or more contributor license agreements.  See the
 * NOTICE file distributed with this work for additional information regarding
 * copyright ownership. The UCAID licenses this file to You under the Apache
 * License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.oidc.metadata.cache.impl;

import java.util.function.Function;

import javax.annotation.Nullable;

import com.nimbusds.oauth2.sdk.id.Issuer;

import net.shibboleth.oidc.metadata.criterion.IssuerIDCriterion;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;

/** Strategy for extracting the {@link IssuerIDCriterion} from a {@link CriteriaSet}. */
public class DefaultOIDCProviderMetadataCriteriaToIdentifierStrategy implements Function<CriteriaSet, Issuer> {

    @Override
    @Nullable
    public Issuer apply(@Nullable final CriteriaSet criteria) {
        if (criteria == null) {
            return null;
        }
        final IssuerIDCriterion issuerId = criteria.get(IssuerIDCriterion.class);
        if (issuerId != null) {
            return issuerId.getIssuerID();
        }
        return null;
    }

}
