/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.metadata;

import com.google.common.base.Objects;
import javax.annotation.Nonnull;
import net.shibboleth.ext.spring.service.AbstractServiceableComponent;
import net.shibboleth.oidc.metadata.ProviderMetadataResolver;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProviderMetadataProviderContainer
extends AbstractServiceableComponent<ProviderMetadataResolver>
implements Comparable<ProviderMetadataProviderContainer> {
    private static int sortKeyValue;
    private final Logger log = LoggerFactory.getLogger(ProviderMetadataProviderContainer.class);
    @NonnullAfterInit
    private ProviderMetadataResolver resolver;
    @NonnullAfterInit
    private Integer sortKey;

    public void setSortKey(int key) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.sortKey = key;
    }

    @Nonnull
    public void setEmbeddedResolver(@Nonnull ProviderMetadataResolver theResolver) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.resolver = (ProviderMetadataResolver)Constraint.isNotNull((Object)theResolver, (String)"ProviderMetadataResolver cannot be null");
    }

    @Nonnull
    public ProviderMetadataResolver getEmbeddedResolver() {
        return this.resolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doInitialize() throws ComponentInitializationException {
        this.setId(this.resolver.getId());
        super.doInitialize();
        if (null == this.resolver) {
            throw new ComponentInitializationException("ProviderMetadataResolver cannot be null");
        }
        if (null != this.sortKey) return;
        Class<ProviderMetadataProviderContainer> clazz = ProviderMetadataProviderContainer.class;
        synchronized (ProviderMetadataProviderContainer.class) {
            this.setSortKey(++sortKeyValue);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.log.info("Top level ProviderMetadata Provider '{}' did not have a sort key; giving it value '{}'", (Object)this.getId(), (Object)this.sortKey);
            return;
        }
    }

    @Nonnull
    public ProviderMetadataResolver getComponent() {
        return this.getEmbeddedResolver();
    }

    @Override
    public int compareTo(ProviderMetadataProviderContainer other) {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        int result = this.sortKey.compareTo(other.sortKey);
        if (result != 0) {
            return result;
        }
        if (this.equals(other)) {
            return 0;
        }
        return this.getId().compareTo(other.getId());
    }

    public boolean equals(Object other) {
        if (null == other) {
            return false;
        }
        if (!(other instanceof ProviderMetadataProviderContainer)) {
            return false;
        }
        ProviderMetadataProviderContainer otherRp = (ProviderMetadataProviderContainer)other;
        return Objects.equal((Object)otherRp.sortKey, (Object)this.sortKey) && Objects.equal((Object)this.getId(), (Object)otherRp.getId());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.sortKey, this.getId()});
    }
}

