/*
 * Licensed to the University Corporation for Advanced Internet Development,
 * Inc. (UCAID) under one or more contributor license agreements.  See the
 * NOTICE file distributed with this work for additional information regarding
 * copyright ownership. The UCAID licenses this file to You under the Apache
 * License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.oidc.metadata.cache;

import java.time.Instant;

import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

/**
 * Context to hold information pertaining to a cache loading event.
 */
@Immutable
public class CacheLoadingContext {
    
    /** Last time the metadata was updated. */
    @Nullable private final Instant lastUpdate;

    /** Last time a refresh cycle occurred. */
    @Nullable private final Instant lastRefresh;

    /**
     * Constructor.
     *
     * @param lastUpdateTime the time of the last successful loading event.
     * @param lastRefreshTime the time of the last refresh attempt.
     */
    public CacheLoadingContext(@Nullable final Instant lastUpdateTime, @Nullable final Instant lastRefreshTime) {
        lastUpdate = lastUpdateTime;
        lastRefresh = lastRefreshTime;
    }

    /**
     * Get the last successful update time.
     * 
     * @return Returns the lastUpdate.
     */
    public final Instant getLastUpdate() {
        return lastUpdate;
    }

    /**
     * Get the last refresh time.
     * 
     * @return Returns the lastRefresh.
     */
    public final Instant getLastRefresh() {
        return lastRefresh;
    }
    
    

}
