/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.logic;

import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.openid.connect.sdk.OIDCScopeValue;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.ValidatedScopeLookupFunction;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;

public class IssueIDTokenCondition
implements Predicate<ProfileRequestContext> {
    @Nonnull
    private Function<ProfileRequestContext, Scope> validatedScopeLookupStrategy = new ValidatedScopeLookupFunction();

    public void setValidatedScopeLookupStrategy(@Nonnull Function<ProfileRequestContext, Scope> strategy) {
        this.validatedScopeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Override
    public boolean test(@Nullable ProfileRequestContext input) {
        if (input == null) {
            return false;
        }
        Scope validatedScope = this.validatedScopeLookupStrategy.apply(input);
        if (validatedScope == null || validatedScope.isEmpty()) {
            return false;
        }
        return validatedScope.contains((Object)OIDCScopeValue.OPENID);
    }
}

