/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.oauth2.sdk.AuthorizationCodeGrant;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.RefreshTokenGrant;
import java.text.ParseException;
import java.time.Duration;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCTokenResponseAction;
import net.shibboleth.idp.plugin.oidc.op.profile.logic.DefaultChainRevocationLifetimeLookupStrategy;
import net.shibboleth.idp.plugin.oidc.op.storage.RevocationCacheContexts;
import net.shibboleth.idp.plugin.oidc.op.token.support.AuthorizeCodeClaimsSet;
import net.shibboleth.idp.plugin.oidc.op.token.support.RefreshTokenClaimsSet;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.oidc.profile.config.logic.RefreshTokensEnabledPredicate;
import net.shibboleth.oidc.profile.config.navigate.RevocationLifetimeLookupFunction;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.security.DataSealer;
import net.shibboleth.utilities.java.support.security.DataSealerException;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.storage.ReplayCache;
import org.opensaml.storage.RevocationCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateGrant
extends AbstractOIDCTokenResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(ValidateGrant.class);
    @Nonnull
    private final DataSealer dataSealer;
    @NonnullAfterInit
    private ReplayCache replayCache;
    @NonnullAfterInit
    private RevocationCache revocationCache;
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyContextLookupStrategy;
    @Nonnull
    private Predicate<ProfileRequestContext> refreshTokensEnabledPredicate;
    @Nonnull
    private Function<ProfileRequestContext, Duration> chainRevocationLifetimeLookupStrategy;
    @Nullable
    private RelyingPartyContext rpCtx;

    public ValidateGrant(@Nonnull @ParameterName(name="sealer") DataSealer sealer) {
        this.dataSealer = (DataSealer)Constraint.isNotNull((Object)sealer, (String)"DataSealer cannot be null");
        this.relyingPartyContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class);
        this.refreshTokensEnabledPredicate = new RefreshTokensEnabledPredicate();
        this.chainRevocationLifetimeLookupStrategy = new DefaultChainRevocationLifetimeLookupStrategy();
        ((RevocationLifetimeLookupFunction)this.chainRevocationLifetimeLookupStrategy).setUseActiveProfileOnly(false);
    }

    public void setRelyingPartyContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.relyingPartyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext lookup strategy cannot be null");
    }

    public void setRefreshTokensEnabledPredicate(@Nonnull Predicate<ProfileRequestContext> predicate) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.refreshTokensEnabledPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"Refresh tokens enabled predicate cannot be null");
    }

    public void setReplayCache(@Nonnull ReplayCache cache) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.replayCache = (ReplayCache)Constraint.isNotNull((Object)cache, (String)"ReplayCache cannot be null");
    }

    public void setRevocationCache(@Nonnull RevocationCache cache) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.revocationCache = (RevocationCache)Constraint.isNotNull((Object)cache, (String)"RevocationCache cannot be null");
    }

    public void setChainRevocationLifetimeLookupStrategy(@Nullable Function<ProfileRequestContext, Duration> strategy) {
        this.chainRevocationLifetimeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.replayCache == null || this.revocationCache == null) {
            throw new ComponentInitializationException("ReplayCache and RevocationCache cannot be null");
        }
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.rpCtx = this.relyingPartyContextLookupStrategy.apply(profileRequestContext);
        if (this.rpCtx == null) {
            this.log.error("{} No relying party context associated with this profile request", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRelyingPartyContext");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        AuthorizationGrant grant = this.getTokenRequest().getAuthorizationGrant();
        this.log.debug("{} Validating grant type: {}", (Object)this.getLogPrefix(), (Object)grant.getType());
        AuthorizeCodeClaimsSet tokenClaimsSet = null;
        if (GrantType.AUTHORIZATION_CODE.equals((Object)grant.getType())) {
            AuthorizationCodeGrant codeGrant = (AuthorizationCodeGrant)grant;
            if (codeGrant.getAuthorizationCode() != null && codeGrant.getAuthorizationCode().getValue() != null) {
                try {
                    AuthorizeCodeClaimsSet authzCodeClaimsSet = AuthorizeCodeClaimsSet.parse((String)codeGrant.getAuthorizationCode().getValue(), (DataSealer)this.dataSealer);
                    this.log.debug("{} Authz code unwrapped {}", (Object)this.getLogPrefix(), (Object)authzCodeClaimsSet.serialize());
                    if (!this.replayCache.check(((Object)((Object)this)).getClass().getName(), authzCodeClaimsSet.getID(), authzCodeClaimsSet.getExp())) {
                        this.log.error("{} Replay detected of authz code {}", (Object)this.getLogPrefix(), (Object)authzCodeClaimsSet.getID());
                        if (!this.revokeChain(authzCodeClaimsSet.getID(), this.chainRevocationLifetimeLookupStrategy.apply(profileRequestContext))) {
                            this.log.warn("{} Fatal error, unable to save replayed code to revocation cache", (Object)this.getLogPrefix());
                        }
                        ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidGrant");
                        return;
                    }
                    tokenClaimsSet = authzCodeClaimsSet;
                }
                catch (ParseException | DataSealerException e) {
                    this.log.warn("{} Unwrapping authz code failed: {}", (Object)this.getLogPrefix(), (Object)e.getMessage());
                    ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidGrant");
                    return;
                }
            }
        } else if (GrantType.REFRESH_TOKEN.equals((Object)grant.getType())) {
            if (!this.refreshTokensEnabledPredicate.test(profileRequestContext)) {
                this.log.warn("{} Refresh token grant detected, but not enabled", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidGrant");
                return;
            }
            RefreshTokenGrant refreshTokentokenGrant = (RefreshTokenGrant)grant;
            if (refreshTokentokenGrant.getRefreshToken() != null && refreshTokentokenGrant.getRefreshToken().getValue() != null) {
                try {
                    String rootJtiToUse;
                    RefreshTokenClaimsSet refreshTokenClaimsSet = RefreshTokenClaimsSet.parse((String)refreshTokentokenGrant.getRefreshToken().getValue(), (DataSealer)this.dataSealer);
                    String rootJti = refreshTokenClaimsSet.getRootTokenIdentifier();
                    if (StringSupport.trimOrNull((String)rootJti) == null) {
                        this.log.warn("{} No root token identifier returned, using JWT id for checking revocation status", (Object)this.getLogPrefix());
                        rootJtiToUse = refreshTokenClaimsSet.getID();
                    } else {
                        rootJtiToUse = rootJti;
                    }
                    if (this.revocationCache.isRevoked(RevocationCacheContexts.AUTHORIZATION_CODE, rootJtiToUse)) {
                        this.log.error("{} Authz code {} and all derived tokens have been revoked", (Object)this.getLogPrefix(), (Object)rootJtiToUse);
                        ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidGrant");
                        return;
                    }
                    if (this.revocationCache.isRevoked(RevocationCacheContexts.SINGLE_ACCESS_OR_REFRESH_TOKENS, refreshTokenClaimsSet.getID())) {
                        this.log.error("{} The refresh token {} has been revoked. Revoking the full chain now.", (Object)this.getLogPrefix(), (Object)refreshTokenClaimsSet.getID());
                        if (!this.revokeChain(rootJtiToUse, this.chainRevocationLifetimeLookupStrategy.apply(profileRequestContext))) {
                            this.log.error("{} Fatal error, unable to store revocation into the revocation cache", (Object)this.getLogPrefix());
                            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
                            return;
                        }
                        ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidGrant");
                        return;
                    }
                    tokenClaimsSet = refreshTokenClaimsSet;
                }
                catch (ParseException | DataSealerException e) {
                    this.log.warn("{} Unwrapping refresh token failed {}", (Object)this.getLogPrefix(), (Object)e.getMessage());
                    ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidGrant");
                    return;
                }
            }
        } else if (GrantType.CLIENT_CREDENTIALS.equals((Object)grant.getType())) {
            return;
        }
        if (tokenClaimsSet == null) {
            this.log.warn("{} Grant type not supported", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidGrant");
            return;
        }
        if (!tokenClaimsSet.isTimeValid()) {
            this.log.warn("{} Token is expired or not net valid", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidGrant");
            return;
        }
        if (!tokenClaimsSet.getClientID().getValue().equals(this.rpCtx.getRelyingPartyId())) {
            this.log.warn("{} Token issued to client {}, invalid for {}", new Object[]{this.getLogPrefix(), tokenClaimsSet.getClientID().getValue(), this.rpCtx.getRelyingPartyId()});
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidGrant");
            return;
        }
        this.getOidcResponseContext().setAuthorizationGrantClaimsSet(tokenClaimsSet);
    }

    protected boolean revokeChain(@Nonnull String id, @Nullable Duration lifetime) {
        if (lifetime == null) {
            this.log.warn("{} No profile-specific revocation lifetime could be resolved, using default value", (Object)this.getLogPrefix());
            return this.revocationCache.revoke(RevocationCacheContexts.AUTHORIZATION_CODE, id);
        }
        return this.revocationCache.revoke(RevocationCacheContexts.AUTHORIZATION_CODE, id, lifetime);
    }
}

