/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.criterion.ClientInformationCriterion;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.DefaultOIDCMetadataContextLookupFunction;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.oidc.metadata.context.OIDCMetadataContext;
import net.shibboleth.oidc.profile.config.logic.EncryptionOptionalPredicate;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.saml2.profile.context.EncryptionContext;
import org.opensaml.xmlsec.EncryptionConfiguration;
import org.opensaml.xmlsec.EncryptionParameters;
import org.opensaml.xmlsec.EncryptionParametersResolver;
import org.opensaml.xmlsec.SecurityConfigurationSupport;
import org.opensaml.xmlsec.criterion.EncryptionConfigurationCriterion;
import org.opensaml.xmlsec.criterion.EncryptionOptionalCriterion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PopulateOIDCEncryptionParameters
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PopulateOIDCEncryptionParameters.class);
    private boolean forDecryption;
    @Nonnull
    private Predicate<ProfileRequestContext> encryptionOptionalPredicate;
    @Nonnull
    private Function<ProfileRequestContext, EncryptionContext> encryptionContextLookupStrategy;
    @NonnullAfterInit
    private Function<ProfileRequestContext, List<EncryptionConfiguration>> configurationLookupStrategy;
    @NonnullAfterInit
    private EncryptionParametersResolver encParamsresolver;
    @Nullable
    @NonnullElements
    private List<EncryptionConfiguration> encryptionConfigurations;
    @Nullable
    private Function<ProfileRequestContext, OIDCMetadataContext> oidcMetadataContextLookupStrategy = new DefaultOIDCMetadataContextLookupFunction();
    private boolean encryptionOptional;
    private EncryptionContext encryptionContext;

    public PopulateOIDCEncryptionParameters() {
        this.encryptionContextLookupStrategy = new ChildContextLookup(EncryptionContext.class, true).compose((Function)new ChildContextLookup(RelyingPartyContext.class));
        this.encryptionOptionalPredicate = new EncryptionOptionalPredicate();
    }

    public void setForDecryption(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.forDecryption = flag;
    }

    public void setEncryptionOptionalPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.encryptionOptionalPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Condition cannot be null");
    }

    public void setEncryptionContextLookupStrategy(@Nonnull Function<ProfileRequestContext, EncryptionContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.encryptionContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"EncryptionContext lookup strategy cannot be null");
    }

    public void setOidcMetadataContextLookupStrategy(@Nonnull Function<ProfileRequestContext, OIDCMetadataContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.oidcMetadataContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)" OIDCMetadataContext lookup strategy cannot be null");
    }

    public void setConfigurationLookupStrategy(@Nonnull Function<ProfileRequestContext, List<EncryptionConfiguration>> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.configurationLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"EncryptionConfiguration lookup strategy cannot be null");
    }

    public void setEncryptionParametersResolver(@Nonnull EncryptionParametersResolver newResolver) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.encParamsresolver = (EncryptionParametersResolver)Constraint.isNotNull((Object)newResolver, (String)"EncryptionParametersResolver cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.encParamsresolver == null) {
            throw new ComponentInitializationException("EncryptionParametersResolver cannot be null");
        }
        if (this.configurationLookupStrategy == null) {
            this.configurationLookupStrategy = new Function<ProfileRequestContext, List<EncryptionConfiguration>>(){

                @Override
                public List<EncryptionConfiguration> apply(ProfileRequestContext input) {
                    return Collections.singletonList(SecurityConfigurationSupport.getGlobalEncryptionConfiguration());
                }
            };
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.encryptionContext = this.encryptionContextLookupStrategy.apply(profileRequestContext);
        if (this.encryptionContext == null) {
            this.log.debug("{} No EncryptionContext returned by lookup strategy", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        if (!this.forDecryption) {
            this.encryptionOptional = this.encryptionOptionalPredicate.test(profileRequestContext);
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        this.log.debug("{} Resolving EncryptionParameters for {}", (Object)this.getLogPrefix(), (Object)(this.forDecryption ? "request object decryption" : "response encryption"));
        try {
            this.encryptionConfigurations = this.configurationLookupStrategy.apply(profileRequestContext);
            if (this.encryptionConfigurations == null || this.encryptionConfigurations.isEmpty()) {
                throw new ResolverException("No EncryptionConfigurations returned by lookup strategy");
            }
            CriteriaSet criteria = this.buildCriteriaSet(profileRequestContext);
            EncryptionParameters params = (EncryptionParameters)this.encParamsresolver.resolveSingle((Object)criteria);
            if (params != null) {
                this.log.debug("{} Resolved EncryptionParameters for {}", (Object)this.getLogPrefix(), (Object)(this.forDecryption ? "request object decryption" : "response encryption"));
                if (this.forDecryption) {
                    this.encryptionContext.setAttributeEncryptionParameters(params);
                } else {
                    this.encryptionContext.setAssertionEncryptionParameters(params);
                }
            } else if (this.encryptionOptional) {
                this.log.debug("{} Resolver returned no EncryptionParameters", (Object)this.getLogPrefix());
                this.log.debug("{} Encryption is optional, ignoring inability to encrypt", (Object)this.getLogPrefix());
            } else {
                this.log.warn("{} Resolver returned no EncryptionParameters", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidSecurityConfiguration");
            }
        }
        catch (ResolverException e) {
            this.log.error("{} Error resolving EncryptionParameters", (Object)this.getLogPrefix(), (Object)e);
            if (this.encryptionOptional) {
                this.log.debug("{} Encryption is optional, ignoring inability to encrypt", (Object)this.getLogPrefix());
            }
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidSecurityConfiguration");
        }
    }

    @Nonnull
    private CriteriaSet buildCriteriaSet(@Nonnull ProfileRequestContext profileRequestContext) {
        OIDCMetadataContext oidcMetadataCtx;
        CriteriaSet criteria = new CriteriaSet(new Criterion[]{new EncryptionConfigurationCriterion(this.encryptionConfigurations)});
        if (!this.forDecryption) {
            criteria.add((Object)new EncryptionOptionalCriterion(this.encryptionOptional));
        }
        if ((oidcMetadataCtx = this.oidcMetadataContextLookupStrategy.apply(profileRequestContext)) != null && oidcMetadataCtx.getClientInformation() != null) {
            this.log.debug("{} Adding OIDC client information to resolution criteria for encryption algorithms", (Object)this.getLogPrefix());
            criteria.add((Object)new ClientInformationCriterion(oidcMetadataCtx.getClientInformation()));
        } else {
            this.log.debug("{} No OIDC client information available", (Object)this.getLogPrefix());
        }
        return criteria;
    }
}

