/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.decoding.impl;

import com.google.common.base.MoreObjects;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.ServletUtils;
import com.nimbusds.openid.connect.sdk.UserInfoRequest;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import net.shibboleth.idp.plugin.oidc.op.decoding.impl.RequestUtil;
import net.shibboleth.idp.plugin.oidc.op.oauth2.decoding.impl.BaseOAuth2RequestDecoder;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OIDCUserInfoRequestDecoder
extends BaseOAuth2RequestDecoder<UserInfoRequest> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(OIDCUserInfoRequestDecoder.class);

    @Override
    protected UserInfoRequest parseMessage() throws MessageDecodingException {
        try {
            HTTPRequest httpReq = ServletUtils.createHTTPRequest((HttpServletRequest)this.getHttpServletRequest());
            this.getProtocolMessageLog().trace("Inbound request {}", (Object)RequestUtil.toString(httpReq));
            return UserInfoRequest.parse((HTTPRequest)httpReq);
        }
        catch (ParseException | IOException e) {
            this.log.error("Unable to decode inbound request: {}", (Object)e.getMessage());
            throw new MessageDecodingException((Exception)e);
        }
    }

    @Override
    protected String getMessageToLog(@Nullable UserInfoRequest message) {
        return message == null ? null : MoreObjects.toStringHelper((Object)((Object)this)).omitNullValues().add("accessToken", (Object)RequestUtil.getAccessTokenLog(message.getAccessToken())).add("method", (Object)message.getMethod()).add("endpointURI", (Object)message.getEndpointURI()).toString();
    }
}

