/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.authn.impl;

import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import java.util.Collections;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.AbstractAuthenticationAction;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.oidc.authn.context.OAuth2ClientAuthenticationContext;
import net.shibboleth.oidc.metadata.context.OIDCMetadataContext;
import net.shibboleth.oidc.profile.config.navigate.TokenEndpointAuthMethodLookupFunction;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateClientAuthenticationType
extends AbstractAuthenticationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ValidateClientAuthenticationType.class);
    @Nonnull
    private Function<ProfileRequestContext, OIDCMetadataContext> oidcMetadataContextLookupStrategy = new ChildContextLookup(OIDCMetadataContext.class).compose((Function)new InboundMessageContextLookup());
    @Nullable
    private Function<ProfileRequestContext, Set<ClientAuthenticationMethod>> tokenEndpointAuthMethodsLookupStrategy = new TokenEndpointAuthMethodLookupFunction();
    @Nullable
    private OIDCMetadataContext oidcMetadataContext;
    @Nullable
    private ClientAuthentication clientAuthentication;
    @Nullable
    @NonnullElements
    private Set<ClientAuthenticationMethod> enabledMethods;

    public void setOIDCMetadataContextLookupStrategy(@Nonnull Function<ProfileRequestContext, OIDCMetadataContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.oidcMetadataContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"OIDCMetadataContext lookup strategy cannot be null");
    }

    public void setTokenEndpointAuthMethodsLookupStrategy(@Nonnull Function<ProfileRequestContext, Set<ClientAuthenticationMethod>> strategy) {
        this.tokenEndpointAuthMethodsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Strategy to obtain enabled token endpoint authentication methods cannot be null");
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        if (!super.doPreExecute(profileRequestContext, authenticationContext)) {
            return false;
        }
        OAuth2ClientAuthenticationContext oauth2Ctx = (OAuth2ClientAuthenticationContext)authenticationContext.getSubcontext(OAuth2ClientAuthenticationContext.class);
        if (oauth2Ctx != null) {
            this.clientAuthentication = oauth2Ctx.getClientAuthentication();
        }
        this.oidcMetadataContext = this.oidcMetadataContextLookupStrategy.apply(profileRequestContext);
        this.enabledMethods = this.tokenEndpointAuthMethodsLookupStrategy.apply(profileRequestContext);
        if (this.enabledMethods == null) {
            this.enabledMethods = Collections.emptySet();
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        ClientAuthenticationMethod used;
        OIDCClientMetadata clientMetadata;
        ClientAuthenticationMethod registeredMethod = this.oidcMetadataContext != null && this.oidcMetadataContext.getClientInformation() != null ? ((clientMetadata = this.oidcMetadataContext.getClientInformation().getOIDCMetadata()).getTokenEndpointAuthMethod() != null ? clientMetadata.getTokenEndpointAuthMethod() : ClientAuthenticationMethod.CLIENT_SECRET_BASIC) : null;
        ClientAuthenticationMethod clientAuthenticationMethod = used = this.clientAuthentication != null ? this.clientAuthentication.getMethod() : ClientAuthenticationMethod.NONE;
        if (registeredMethod != null && !registeredMethod.equals((Object)used)) {
            this.log.warn("{} Client '{}' registered {} but attempted {}", new Object[]{this.getLogPrefix(), this.getClientID(), registeredMethod, used});
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"AccessDenied");
        } else if (!this.enabledMethods.contains(used)) {
            this.log.warn("{} Requested method {} not enabled in profile configuration", (Object)this.getLogPrefix(), (Object)used);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"AccessDenied");
        }
    }

    @Nullable
    private String getClientID() {
        if (this.oidcMetadataContext != null && this.oidcMetadataContext.getClientInformation() != null) {
            return this.oidcMetadataContext.getClientInformation().getID().getValue();
        }
        if (this.clientAuthentication != null && this.clientAuthentication.getClientID() != null) {
            return this.clientAuthentication.getClientID().getValue();
        }
        return null;
    }
}

