/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.audit.impl;

import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import com.nimbusds.openid.connect.sdk.Prompt;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;

public class ForceAuthnAuditExtractor
implements Function<ProfileRequestContext, Boolean> {
    @Nonnull
    private final Function<ProfileRequestContext, AuthenticationRequest> requestLookupStrategy;

    public ForceAuthnAuditExtractor(@Nonnull Function<ProfileRequestContext, AuthenticationRequest> strategy) {
        this.requestLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"AuthenticationRequest lookup strategy cannot be null");
    }

    @Override
    @Nullable
    public Boolean apply(@Nullable ProfileRequestContext input) {
        AuthenticationRequest request = this.requestLookupStrategy.apply(input);
        if (request != null && request.getPrompt() != null) {
            return request.getPrompt().contains((Object)Prompt.Type.LOGIN);
        }
        return null;
    }
}

