/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.admin.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.nimbusds.oauth2.sdk.AccessTokenResponse;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.oauth2.sdk.token.Tokens;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.ServletRequest;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.SubjectContext;
import net.shibboleth.idp.plugin.oidc.op.admin.impl.AbstractAdminApiProfileAction;
import net.shibboleth.idp.plugin.oidc.op.token.support.RegistrationClaimsSet;
import net.shibboleth.idp.profile.context.navigate.ResponderIdLookupFunction;
import net.shibboleth.idp.profile.function.SpringFlowScopeLookupFunction;
import net.shibboleth.oidc.metadata.policy.MetadataPolicy;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.security.AccessControlService;
import net.shibboleth.utilities.java.support.security.DataSealer;
import net.shibboleth.utilities.java.support.security.DataSealerException;
import net.shibboleth.utilities.java.support.security.IdentifierGenerationStrategy;
import net.shibboleth.utilities.java.support.security.impl.SecureRandomIdentifierGenerationStrategy;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IssueRegistrationAccessToken
extends AbstractAdminApiProfileAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(IssueRegistrationAccessToken.class);
    @NonnullAfterInit
    private DataSealer dataSealer;
    @Nonnull
    private Function<ProfileRequestContext, IdentifierGenerationStrategy> idGeneratorLookupStrategy = FunctionSupport.constant((Object)new SecureRandomIdentifierGenerationStrategy());
    @NonnullAfterInit
    private AccessControlService accessControlService;
    @Nullable
    @NotEmpty
    private String policyLocationPolicyName;
    @Nullable
    @NotEmpty
    private String policyIdPolicyName;
    @Nullable
    @NotEmpty
    private String clientIdPolicyName;
    @NonnullAfterInit
    private Function<ProfileRequestContext, Map<String, MetadataPolicy>> metadataPolicyLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, String> tokenLifetimeLookupStrategy;
    @NonnullAfterInit
    private Function<ProfileRequestContext, String> issuerLookupStrategy = new ResponderIdLookupFunction();
    @Nonnull
    private Function<ProfileRequestContext, String> policyLocationLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, String> policyIdLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, String> clientIdLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, String> replacementLookupStrategy;
    @Nullable
    private IdentifierGenerationStrategy idGenerator;
    @Nullable
    private Map<String, MetadataPolicy> metadataPolicy;
    @Nonnull
    private String issuer;
    @Nullable
    private String policyLocation;
    @Nullable
    private String policyId;
    @Nullable
    private String clientId;
    @Nullable
    private Duration defaultTokenLifetime;
    @Nullable
    private Duration tokenLifetime;

    public IssueRegistrationAccessToken() {
        this.tokenLifetimeLookupStrategy = new SpringFlowScopeLookupFunction("tokenLifetime");
        this.policyLocationLookupStrategy = new SpringFlowScopeLookupFunction("policyLocation");
        this.policyIdLookupStrategy = new SpringFlowScopeLookupFunction("policyId");
        this.clientIdLookupStrategy = new SpringFlowScopeLookupFunction("clientId");
        this.replacementLookupStrategy = new SpringFlowScopeLookupFunction("replacement");
        this.defaultTokenLifetime = Duration.ofDays(1L);
    }

    public void setSealer(@Nonnull DataSealer sealer) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.dataSealer = (DataSealer)Constraint.isNotNull((Object)sealer, (String)"Data sealer cannot be null");
    }

    public void setAccessControlService(@Nonnull AccessControlService acs) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.accessControlService = (AccessControlService)Constraint.isNotNull((Object)acs, (String)"AccessControlService cannot be null");
    }

    public void setIdentifierGeneratorLookupStrategy(@Nonnull Function<ProfileRequestContext, IdentifierGenerationStrategy> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.idGeneratorLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"IdentifierGenerationStrategy lookup strategy cannot be null");
    }

    public void setIssuerLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.issuerLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Issuer lookup strategy cannot be null");
    }

    public void setMetadataPolicyLookupStrategy(@Nonnull Function<ProfileRequestContext, Map<String, MetadataPolicy>> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.metadataPolicyLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Metadata policy lookup strategy cannot be null");
    }

    public void setTokenLifetimeLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.tokenLifetimeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Token lifetime lookup strategy cannot be null");
    }

    public void setPolicyLocationLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.policyLocationLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Policy location lookup strategy cannot be null");
    }

    public void setPolicyIdLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.policyIdLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Policy ID lookup strategy cannot be null");
    }

    public void setClientIdLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.clientIdLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Client ID lookup strategy cannot be null");
    }

    public void setReplacementLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.replacementLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Replacement lookup strategy cannot be null");
    }

    public void setPolicyLocationPolicyName(@Nullable @NotEmpty String name) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.policyLocationPolicyName = StringSupport.trimOrNull((String)name);
    }

    public void setPolicyIdPolicyName(@Nullable @NotEmpty String name) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.policyIdPolicyName = StringSupport.trimOrNull((String)name);
    }

    public void setClientIdPolicyName(@Nullable @NotEmpty String name) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.clientIdPolicyName = StringSupport.trimOrNull((String)name);
    }

    public void setDefaultTokenLifetime(@Nonnull Duration lifetime) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.defaultTokenLifetime = (Duration)Constraint.isNotNull((Object)lifetime, (String)"Default token lifetime cannot be null");
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.dataSealer == null) {
            throw new ComponentInitializationException("DataSealer cannot be null");
        }
        if (this.accessControlService == null) {
            throw new ComponentInitializationException("AccessControlService cannot be null");
        }
        if (this.metadataPolicyLookupStrategy == null) {
            throw new ComponentInitializationException("Metadata policy lookup strategy cannot be null");
        }
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.idGenerator = this.idGeneratorLookupStrategy.apply(profileRequestContext);
        try {
            if (this.idGenerator == null) {
                this.log.error("{} No identifier generation strategy", (Object)this.getLogPrefix());
                this.sendError(500, "Internal Server Error", "System misconfiguration.");
                return false;
            }
            this.issuer = this.issuerLookupStrategy.apply(profileRequestContext);
            if (this.issuer == null) {
                this.log.error("{} No issuer could be resolved", (Object)this.getLogPrefix());
                this.sendError(500, "Internal Server Error", "System misconfiguration.");
                return false;
            }
            this.policyLocation = this.policyLocationLookupStrategy.apply(profileRequestContext);
            this.policyId = this.policyIdLookupStrategy.apply(profileRequestContext);
            this.metadataPolicy = this.metadataPolicyLookupStrategy.apply(profileRequestContext);
            if (this.policyLocation != null && this.metadataPolicy == null) {
                this.log.warn("{} No metadata policy could be resolved from the given location: {}", (Object)this.getLogPrefix(), (Object)this.policyLocation);
                this.sendError(400, "Invalid Request", "No metadata policy or policy ID could be resolved.");
                return false;
            }
            if (this.metadataPolicy == null && this.policyId == null) {
                this.log.warn("{} No metadata policy or policy ID could be resolved", (Object)this.getLogPrefix());
                this.sendError(400, "Invalid Request", "No metadata policy or policy ID could be resolved.");
                return false;
            }
        }
        catch (IOException e) {
            this.log.error("{} I/O error issuing API response", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InputOutputError");
            return false;
        }
        this.clientId = this.clientIdLookupStrategy.apply(profileRequestContext);
        String lifetimeString = this.tokenLifetimeLookupStrategy.apply(profileRequestContext);
        if (lifetimeString != null) {
            try {
                this.tokenLifetime = Duration.parse(lifetimeString);
                if (this.tokenLifetime.compareTo(this.defaultTokenLifetime) > 0) {
                    this.log.warn("Requested token lifetime greater than default, lowering to default", (Object)this.getLogPrefix());
                    this.tokenLifetime = this.defaultTokenLifetime;
                }
            }
            catch (DateTimeParseException e) {
                this.log.warn("{} Token lifetime was not in a supported format", (Object)this.getLogPrefix(), (Object)e);
            }
        } else {
            this.log.debug("{} No token lifetime specified, using default", (Object)this.getLogPrefix());
            this.tokenLifetime = this.defaultTokenLifetime;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        BearerAccessToken accessToken;
        if (!this.checkAccess(profileRequestContext)) {
            return;
        }
        String id = this.idGenerator.generateIdentifier();
        Instant now = Instant.now();
        Instant exp = now.plus(this.tokenLifetime);
        RegistrationClaimsSet.Builder builder = new RegistrationClaimsSet.Builder(id).withIssuer(this.issuer).withIssuedAt(now).withExpiration(exp).withMetadata(this.metadataPolicy).withRelyingPartyId(this.policyId);
        if (this.clientId != null) {
            builder.withClientId(this.clientId).withReplacement(Boolean.valueOf(this.replacementLookupStrategy.apply(profileRequestContext)));
        }
        this.addAuthenticationClaims(profileRequestContext, builder);
        RegistrationClaimsSet claimsSet = builder.build();
        try {
            String value = this.getObjectMapper().writeValueAsString((Object)claimsSet);
            this.log.debug("{} Built the following JSON to be sealed {}", (Object)this.getLogPrefix(), (Object)value);
            String encryptedValue = this.dataSealer.wrap(value, claimsSet.getExpiration());
            this.log.debug("{} Encrypted the JSON into {}", (Object)this.getLogPrefix(), (Object)encryptedValue);
            accessToken = new BearerAccessToken(encryptedValue, this.tokenLifetime.getSeconds(), null);
        }
        catch (JsonProcessingException e) {
            this.log.error("{} Could not build JSON", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InputOutputError");
            return;
        }
        catch (DataSealerException e) {
            this.log.error("{} Could not encrypt the claims set", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InputOutputError");
            return;
        }
        AccessTokenResponse response = new AccessTokenResponse(new Tokens((AccessToken)accessToken, null));
        MessageContext mc = new MessageContext();
        mc.setMessage((Object)response);
        profileRequestContext.setOutboundMessageContext(mc);
    }

    private boolean checkAccess(@Nonnull ProfileRequestContext profileRequestContext) {
        try {
            if (this.policyId != null) {
                if (this.policyIdPolicyName == null) {
                    this.log.warn("{} No policy name govering policyId usage, disallowing access", (Object)this.getLogPrefix());
                    this.sendError(403, "Access Denied", "No policy name govering policyId usage, disallowing access.");
                    return false;
                }
                if (!this.accessControlService.getInstance(this.policyIdPolicyName).checkAccess((ServletRequest)this.getHttpServletRequest(), "read", this.policyId)) {
                    this.sendError(403, "Access Denied", "Operation is not allowed with the current policy.");
                    return false;
                }
            }
            if (this.policyLocation != null) {
                if (this.policyLocationPolicyName == null) {
                    this.log.warn("{} No policy name govering policyLocation usage, disallowing access", (Object)this.getLogPrefix());
                    this.sendError(403, "Access Denied", "No policy name govering policyId usage, disallowing access.");
                    return false;
                }
                if (!this.accessControlService.getInstance(this.policyLocationPolicyName).checkAccess((ServletRequest)this.getHttpServletRequest(), "read", this.policyLocation)) {
                    this.sendError(403, "Access Denied", "Operation is not allowed with the current policy.");
                    return false;
                }
            }
            if (this.clientId != null) {
                if (this.clientIdPolicyName == null) {
                    this.log.warn("{} No policy name govering clientId usage, disallowing access", (Object)this.getLogPrefix());
                    this.sendError(403, "Access Denied", "No policy name govering policyId usage, disallowing access.");
                    return false;
                }
                if (!this.accessControlService.getInstance(this.clientIdPolicyName).checkAccess((ServletRequest)this.getHttpServletRequest(), "write", this.clientId)) {
                    this.sendError(403, "Access Denied", "Operation is not allowed with the current policy.");
                    return false;
                }
            }
        }
        catch (IOException e) {
            this.log.error("{} I/O error issuing API response", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InputOutputError");
            return false;
        }
        return true;
    }

    private void addAuthenticationClaims(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull RegistrationClaimsSet.Builder builder) {
        SubjectContext subjectContext;
        AuthenticationContext authnContext = (AuthenticationContext)profileRequestContext.getSubcontext(AuthenticationContext.class);
        if (authnContext != null && authnContext.getAuthenticationResult() != null) {
            builder.withAuthTime(authnContext.getAuthenticationResult().getAuthenticationInstant());
        }
        if ((subjectContext = (SubjectContext)profileRequestContext.getSubcontext(SubjectContext.class)) != null && subjectContext.getPrincipalName() != null) {
            builder.withPrincipal(subjectContext.getPrincipalName());
        }
    }
}

