/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.admin.impl;

import com.google.common.base.Strings;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.idp.plugin.oidc.op.admin.impl.AbstractAdminApiProfileAction;
import net.shibboleth.idp.profile.context.SpringRequestContext;
import net.shibboleth.oidc.metadata.ClientInformationManager;
import net.shibboleth.oidc.metadata.ClientInformationManagerException;
import net.shibboleth.oidc.metadata.ClientInformationResolver;
import net.shibboleth.oidc.metadata.criterion.ClientIDCriterion;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.RequestContext;

public class DoClientManagementOperation
extends AbstractAdminApiProfileAction {
    @Nonnull
    @NotEmpty
    public static final String CLIENT_ID = "clientId";
    @Nonnull
    private Logger log = LoggerFactory.getLogger(DoClientManagementOperation.class);
    @NonnullAfterInit
    private ClientInformationResolver resolver;
    @NonnullAfterInit
    private ClientInformationManager manager;
    @Nullable
    @NotEmpty
    private String clientId;

    public void setClientInformationResolver(@Nonnull ClientInformationResolver theResolver) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.resolver = (ClientInformationResolver)Constraint.isNotNull((Object)theResolver, (String)"ClientInformationResolver cannot be null");
    }

    public void setClientInformationManager(@Nonnull ClientInformationManager theManager) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.manager = (ClientInformationManager)Constraint.isNotNull((Object)theManager, (String)"ClientInformationManager cannot be null");
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.resolver == null) {
            throw new ComponentInitializationException("ClientInformationResolver cannot be null");
        }
        if (this.manager == null) {
            throw new ComponentInitializationException("ClientInformationManager cannot be null");
        }
    }

    @Override
    protected boolean doPreExecute(ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        try {
            SpringRequestContext springRequestContext = (SpringRequestContext)profileRequestContext.getSubcontext(SpringRequestContext.class);
            if (springRequestContext == null) {
                this.log.warn("{} Spring request context not found in profile request context", (Object)this.getLogPrefix());
                this.sendError(500, "Internal Server Error", "System misconfiguration.");
                return false;
            }
            RequestContext requestContext = springRequestContext.getRequestContext();
            if (requestContext == null) {
                this.log.warn("{} Web Flow request context not found in Spring request context", (Object)this.getLogPrefix());
                this.sendError(500, "Internal Server Error", "System misconfiguration.");
                return false;
            }
            this.clientId = (String)requestContext.getFlowScope().get(CLIENT_ID);
            if (Strings.isNullOrEmpty((String)this.clientId)) {
                this.sendError(404, "Missing client_id", "No client identifier specified.");
                return false;
            }
        }
        catch (IOException e) {
            this.log.error("{} I/O error issuing API response", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InputOutputError");
            return false;
        }
        return true;
    }

    protected void doExecute(ProfileRequestContext profileRequestContext) {
        block10: {
            try {
                HttpServletRequest request = this.getHttpServletRequest();
                HttpServletResponse response = this.getHttpServletResponse();
                response.setContentType("application/json");
                response.setHeader("Cache-Control", "must-revalidate,no-cache,no-store");
                if ("GET".equals(request.getMethod())) {
                    try {
                        OIDCClientInformation record = (OIDCClientInformation)this.resolver.resolveSingle((Object)new CriteriaSet(new Criterion[]{new ClientIDCriterion(new ClientID(this.clientId))}));
                        if (record != null) {
                            response.setContentType("application/json");
                            response.setStatus(200);
                            response.getOutputStream().print(record.toJSONObject().toJSONString());
                            break block10;
                        }
                        this.sendError(404, "Record Not Found", "The specified record was not present or has expired.");
                    }
                    catch (ResolverException e) {
                        this.log.error("{} Resolver error looking up client ID {}", new Object[]{this.getLogPrefix(), this.clientId, e});
                        this.sendError(500, "Internal Server Error", "Client info resolution error.");
                    }
                    break block10;
                }
                if ("DELETE".equals(request.getMethod())) {
                    try {
                        this.manager.destroyClientInformation(new ClientID(this.clientId));
                        response.setStatus(204);
                    }
                    catch (ClientInformationManagerException e) {
                        this.log.error("{} Error deleting client ID {}", new Object[]{this.getLogPrefix(), this.clientId, e});
                        this.sendError(500, "Internal Server Error", "ClientInformationManager error.");
                    }
                } else {
                    this.log.warn("{} Invalid method: {}", (Object)this.getLogPrefix(), (Object)request.getMethod());
                    this.sendError(405, "Unknown Operation", "Only GET and DELETE are supported.");
                }
            }
            catch (IOException e) {
                this.log.error("{} I/O error responding to request", (Object)this.getLogPrefix(), (Object)e);
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InputOutputError");
            }
        }
    }
}

