/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.logic;

import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseContext;
import net.shibboleth.idp.plugin.oidc.op.profile.logic.SubjectActivationCondition;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class SubjectActivationConditionTest {
    private SubjectActivationCondition lookup;
    protected ProfileRequestContext prc;
    protected OIDCAuthenticationResponseContext respCtx;

    @BeforeMethod
    public void setup() throws ComponentInitializationException {
        this.lookup = new SubjectActivationCondition();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(new RequestContextBuilder().buildRequestContext());
        this.prc.setOutboundMessageContext(new MessageContext());
        this.respCtx = new OIDCAuthenticationResponseContext();
        this.respCtx.setSubject("joe");
        this.prc.getOutboundMessageContext().addSubcontext((BaseContext)this.respCtx);
    }

    @Test
    public void testSubjectExists() {
        Assert.assertFalse((boolean)this.lookup.test(this.prc));
    }

    @Test
    public void testNoSubject() {
        this.respCtx.setSubject(null);
        Assert.assertTrue((boolean)this.lookup.test(this.prc));
    }

    @Test
    public void testNoOIDCResponseCtx() {
        this.prc.getOutboundMessageContext().removeSubcontext(OIDCAuthenticationResponseContext.class);
        Assert.assertTrue((boolean)this.lookup.test(this.prc));
    }

    @Test
    public void testNoOutboundCtx() {
        this.prc.setOutboundMessageContext(null);
        Assert.assertTrue((boolean)this.lookup.test(this.prc));
    }
}

