/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import net.shibboleth.ext.spring.testing.MockApplicationContext;
import net.shibboleth.idp.attribute.AttributesMapContainer;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.context.AttributeContext;
import net.shibboleth.idp.attribute.transcoding.BasicNamingFunction;
import net.shibboleth.idp.attribute.transcoding.TranscodingRule;
import net.shibboleth.idp.attribute.transcoding.impl.AttributeTranscoderRegistryImpl;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseTokenClaimsContext;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.BaseOIDCResponseActionTest;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.SetTokenDeliveryAttributesToResponseContext;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.oidc.attribute.transcoding.AbstractOIDCAttributeTranscoder;
import net.shibboleth.oidc.attribute.transcoding.impl.OIDCStringAttributeTranscoder;
import net.shibboleth.oidc.profile.config.OIDCAuthorizationConfiguration;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.service.ReloadableService;
import net.shibboleth.utilities.java.support.service.ServiceableComponent;
import net.shibboleth.utilities.java.support.test.service.MockReloadableService;
import org.opensaml.messaging.context.BaseContext;
import org.springframework.context.ApplicationContext;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class SetTokenDeliveryAttributesToResponseContextTest
extends BaseOIDCResponseActionTest {
    private AttributeTranscoderRegistryImpl registry;
    private SetTokenDeliveryAttributesToResponseContext action;

    @BeforeMethod
    public void setup() throws ComponentInitializationException {
        ((OIDCAuthorizationConfiguration)this.rpCtx.getProfileConfig()).setEncodedAttributes(Set.of("test1", "test2", "test3", "test4"));
        ((OIDCAuthorizationConfiguration)this.rpCtx.getProfileConfig()).setAlwaysIncludedAttributes(Set.of("test2", "test3"));
        ((OIDCAuthorizationConfiguration)this.rpCtx.getProfileConfig()).setDeniedUserInfoAttributes(Set.of("test2", "test4"));
        this.registry = new AttributeTranscoderRegistryImpl();
        this.registry.setId("test");
        OIDCStringAttributeTranscoder transcoder = new OIDCStringAttributeTranscoder();
        transcoder.initialize();
        HashMap<String, String> rule1 = new HashMap<String, String>();
        rule1.put("id", "test1");
        rule1.put("transcoder", (String)transcoder);
        rule1.put("oidc.name", "test1");
        HashMap<String, String> rule2 = new HashMap<String, String>();
        rule2.put("id", "test2");
        rule2.put("transcoder", (String)transcoder);
        rule2.put("oidc.name", "test2");
        HashMap<String, String> rule3 = new HashMap<String, String>();
        rule3.put("id", "test3");
        rule3.put("transcoder", (String)transcoder);
        rule3.put("oidc.name", "test3");
        HashMap<String, String> rule4 = new HashMap<String, String>();
        rule4.put("id", "test4");
        rule4.put("transcoder", (String)transcoder);
        rule4.put("oidc.name", "test4");
        this.registry.setNamingRegistry(Collections.singletonList(new BasicNamingFunction(transcoder.getEncodedType(), (Function)new AbstractOIDCAttributeTranscoder.NamingFunction())));
        this.registry.setTranscoderRegistry(List.of(new TranscodingRule(rule1), new TranscodingRule(rule2), new TranscodingRule(rule3), new TranscodingRule(rule4)));
        this.registry.setApplicationContext((ApplicationContext)new MockApplicationContext());
        this.registry.initialize();
        this.action = new SetTokenDeliveryAttributesToResponseContext();
        this.action.setTranscoderRegistry((ReloadableService)new MockReloadableService((ServiceableComponent)this.registry));
        this.action.initialize();
    }

    @AfterMethod
    public void tearDown() {
        this.registry.destroy();
        this.registry = null;
    }

    private void setAttributeContext() {
        IdPAttribute attribute1 = new IdPAttribute("test1");
        ArrayList<StringAttributeValue> stringAttributeValues1 = new ArrayList<StringAttributeValue>();
        stringAttributeValues1.add(new StringAttributeValue("value1"));
        stringAttributeValues1.add(new StringAttributeValue("value2"));
        attribute1.setValues(stringAttributeValues1);
        IdPAttribute attribute2 = new IdPAttribute("test2");
        ArrayList<StringAttributeValue> stringAttributeValues2 = new ArrayList<StringAttributeValue>();
        stringAttributeValues2.add(new StringAttributeValue("value"));
        attribute2.setValues(stringAttributeValues2);
        IdPAttribute attribute3 = new IdPAttribute("test3");
        ArrayList<StringAttributeValue> stringAttributeValues3 = new ArrayList<StringAttributeValue>();
        stringAttributeValues3.add(new StringAttributeValue("value3"));
        attribute3.setValues(stringAttributeValues3);
        IdPAttribute attribute4 = new IdPAttribute("test4");
        ArrayList<StringAttributeValue> stringAttributeValues4 = new ArrayList<StringAttributeValue>();
        stringAttributeValues4.add(new StringAttributeValue("value4"));
        attribute4.setValues(stringAttributeValues4);
        AttributeContext attributeCtx = new AttributeContext();
        ArrayList<IdPAttribute> attributes = new ArrayList<IdPAttribute>();
        attributes.add(attribute1);
        attributes.add(attribute2);
        attributes.add(attribute3);
        attributes.add(attribute4);
        attributeCtx.setIdPAttributes(attributes);
        ((RelyingPartyContext)this.profileRequestCtx.getSubcontext(RelyingPartyContext.class)).addSubcontext((BaseContext)attributeCtx);
    }

    @Test
    public void testNoAttributeCtx() {
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNull((Object)this.respCtx.getSubcontext(OIDCAuthenticationResponseTokenClaimsContext.class));
    }

    @Test
    public void testSuccess() {
        this.setAttributeContext();
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        OIDCAuthenticationResponseTokenClaimsContext respTokenClaims = (OIDCAuthenticationResponseTokenClaimsContext)this.respCtx.getSubcontext(OIDCAuthenticationResponseTokenClaimsContext.class);
        Assert.assertNotNull((Object)respTokenClaims);
        Assert.assertNull((Object)respTokenClaims.getClaims().getClaim("test1"));
        Assert.assertNull((Object)respTokenClaims.getIdtokenClaims().getClaim("test1"));
        Assert.assertEquals((Object)respTokenClaims.getUserinfoClaims().getClaim("test1"), (Object)"value1 value2");
        Assert.assertNull((Object)respTokenClaims.getClaims().getClaim("test2"));
        Assert.assertEquals((Object)respTokenClaims.getIdtokenClaims().getClaim("test2"), (Object)"value");
        Assert.assertNull((Object)respTokenClaims.getUserinfoClaims().getClaim("test2"));
        Assert.assertEquals((Object)respTokenClaims.getClaims().getClaim("test3"), (Object)"value3");
        Assert.assertNull((Object)respTokenClaims.getIdtokenClaims().getClaim("test3"));
        Assert.assertNull((Object)respTokenClaims.getUserinfoClaims().getClaim("test3"));
        Assert.assertNull((Object)respTokenClaims.getClaims().getClaim("test4"));
        Assert.assertNull((Object)respTokenClaims.getIdtokenClaims().getClaim("test4"));
        Assert.assertNull((Object)respTokenClaims.getUserinfoClaims().getClaim("test4"));
    }

    @Test
    public void testSuccessWithClaimsRequestedToIdToken() {
        this.setAttributeContext();
        HashMultimap map = HashMultimap.create();
        map.put((Object)"test1", (Object)new IdPAttribute("test1"));
        map.put((Object)"test4", (Object)new IdPAttribute("test4"));
        AttributesMapContainer container = new AttributesMapContainer((Multimap)map);
        this.respCtx.setMappedIdTokenRequestedClaims(container);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        OIDCAuthenticationResponseTokenClaimsContext respTokenClaims = (OIDCAuthenticationResponseTokenClaimsContext)this.respCtx.getSubcontext(OIDCAuthenticationResponseTokenClaimsContext.class);
        Assert.assertNotNull((Object)respTokenClaims);
        Assert.assertEquals((Object)respTokenClaims.getClaims().getClaim("test1"), (Object)"value1 value2");
        Assert.assertNull((Object)respTokenClaims.getIdtokenClaims().getClaim("test1"));
        Assert.assertNull((Object)respTokenClaims.getUserinfoClaims().getClaim("test1"));
        Assert.assertNull((Object)respTokenClaims.getClaims().getClaim("test2"));
        Assert.assertEquals((Object)respTokenClaims.getIdtokenClaims().getClaim("test2"), (Object)"value");
        Assert.assertNull((Object)respTokenClaims.getUserinfoClaims().getClaim("test2"));
        Assert.assertEquals((Object)respTokenClaims.getClaims().getClaim("test3"), (Object)"value3");
        Assert.assertNull((Object)respTokenClaims.getIdtokenClaims().getClaim("test3"));
        Assert.assertNull((Object)respTokenClaims.getUserinfoClaims().getClaim("test3"));
        Assert.assertNull((Object)respTokenClaims.getClaims().getClaim("test4"));
        Assert.assertEquals((Object)respTokenClaims.getIdtokenClaims().getClaim("test4"), (Object)"value4");
        Assert.assertNull((Object)respTokenClaims.getUserinfoClaims().getClaim("test4"));
    }
}

