/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import java.time.Instant;
import javax.security.auth.Subject;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.BaseOIDCResponseActionTest;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.SetAuthenticationTimeToResponseContext;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SetAuthenticationTimeToResponseContextTest
extends BaseOIDCResponseActionTest {
    private SetAuthenticationTimeToResponseContext action;

    private void init() throws ComponentInitializationException {
        this.action = new SetAuthenticationTimeToResponseContext();
        this.action.initialize();
    }

    @Test
    public void testNoAuthTime() throws ComponentInitializationException {
        this.init();
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidProfileContext");
    }

    @Test
    public void testSuccess() throws ComponentInitializationException {
        this.init();
        AuthenticationContext authCtx = (AuthenticationContext)this.profileRequestCtx.getSubcontext(AuthenticationContext.class, true);
        AuthenticationResult result = new AuthenticationResult("id", new Subject());
        result.setAuthenticationInstant(Instant.ofEpochMilli(1000L));
        authCtx.setAuthenticationResult(result);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertEquals((Object)this.respCtx.getAuthTime(), (Object)Instant.ofEpochMilli(1000L));
    }
}

