/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.flow;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import com.nimbusds.oauth2.sdk.id.ClientID;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.shibboleth.idp.plugin.oidc.op.oauth2.messaging.impl.OAuth2RevocationSuccessResponse;
import net.shibboleth.idp.plugin.oidc.op.profile.flow.AbstractOidcClientAuthenticationFlowTest;
import net.shibboleth.idp.plugin.oidc.op.storage.RevocationCacheContexts;
import net.shibboleth.idp.plugin.oidc.op.token.support.AccessTokenClaimsSet;
import net.shibboleth.oidc.security.credential.JWKCredential;
import net.shibboleth.utilities.java.support.collection.Pair;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.security.DataSealerException;
import org.opensaml.storage.RevocationCache;
import org.opensaml.storage.StorageService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.executor.FlowExecutionResult;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

public class RevocationFlowTest
extends AbstractOidcClientAuthenticationFlowTest {
    public static final String FLOW_ID = "oauth2/revocation";
    String clientIdSingle = "mockClientIdRefreshTokenRotation";
    Scope scope = Scope.parse((String)"openid profile email");
    @Autowired
    @Qualifier(value="testbed.DefaultRSSigningCredential")
    private JWKCredential signingKey = null;
    @Autowired
    @Qualifier(value="shibboleth.StorageService")
    StorageService storageService;
    @Autowired
    @Qualifier(value="shibboleth.oidc.RevocationCache")
    RevocationCache revocationCache;

    public RevocationFlowTest() {
        super(FLOW_ID);
    }

    @AfterMethod
    public void tearDown() throws IOException {
        this.removeMetadata(this.storageService, this.clientId);
        this.removeMetadata(this.storageService, this.clientIdSingle);
    }

    @Test
    public void testUntrustedClient() throws IOException, NoSuchAlgorithmException, URISyntaxException, DataSealerException, ComponentInitializationException {
        this.setBasicAuth(this.clientId, this.clientSecret + "bad");
        this.setHttpFormRequest("POST", Collections.singletonMap("token", super.buildToken(this.clientId, "sub", Scope.parse((String)"openid")).toJSONObject().getAsString("access_token")));
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        this.assertErrorCode(result, "invalid_client");
    }

    @Test
    public void testFailedAuthentication() throws IOException, NoSuchAlgorithmException, URISyntaxException, DataSealerException, ComponentInitializationException {
        this.setBasicAuth(this.clientId, this.clientSecret + "X");
        this.storeMetadata(this.storageService, this.clientId, this.clientSecret, this.scope, new String[0]);
        this.setHttpFormRequest("POST", Collections.singletonMap("token", super.buildLegacyToken(this.clientId, "sub", Scope.parse((String)"openid"), "mail").toJSONObject().getAsString("access_token")));
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        this.assertErrorCode(result, "invalid_client");
    }

    @Test
    public void testSuccessUnverified() throws IOException, NoSuchAlgorithmException, URISyntaxException, DataSealerException, ComponentInitializationException {
        this.setBasicAuth(this.clientId, this.clientSecret);
        this.setHttpFormRequest("POST", Collections.singletonMap("token", super.buildToken(this.clientId, "sub", Scope.parse((String)"openid")).toJSONObject().getAsString("access_token")));
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        this.parseSuccessResponse(result, OAuth2RevocationSuccessResponse.class);
    }

    @Test
    public void testSuccess() throws IOException, NoSuchAlgorithmException, URISyntaxException, DataSealerException, ComponentInitializationException {
        String id = this.idGenerator.generateIdentifier();
        String rootId = this.idGenerator.generateIdentifier();
        this.setBasicAuth(this.clientId, this.clientSecret);
        this.storeMetadata(this.storageService, this.clientId, this.clientSecret, this.scope, new String[0]);
        this.setHttpFormRequest("POST", Collections.singletonMap("token", super.buildToken(this.clientId, "sub", Scope.parse((String)"openid"), null, id, rootId).toJSONObject().getAsString("access_token")));
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        this.parseSuccessResponse(result, OAuth2RevocationSuccessResponse.class);
        Assert.assertFalse((boolean)this.revocationCache.isRevoked(RevocationCacheContexts.SINGLE_ACCESS_OR_REFRESH_TOKENS, id));
        Assert.assertTrue((boolean)this.revocationCache.isRevoked(RevocationCacheContexts.AUTHORIZATION_CODE, rootId));
    }

    @Test
    public void testSuccessSingleAccessToken() throws IOException, NoSuchAlgorithmException, URISyntaxException, DataSealerException, ComponentInitializationException {
        String id = this.idGenerator.generateIdentifier();
        String rootId = this.idGenerator.generateIdentifier();
        this.setBasicAuth(this.clientIdSingle, this.clientSecret);
        this.storeMetadata(this.storageService, this.clientIdSingle, this.clientSecret, this.scope, new String[0]);
        this.setHttpFormRequest("POST", Collections.singletonMap("token", super.buildToken(this.clientIdSingle, "sub", Scope.parse((String)"openid"), null, id, rootId).toJSONObject().getAsString("access_token")));
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        this.parseSuccessResponse(result, OAuth2RevocationSuccessResponse.class);
        Assert.assertTrue((boolean)this.revocationCache.isRevoked(RevocationCacheContexts.SINGLE_ACCESS_OR_REFRESH_TOKENS, id));
        Assert.assertFalse((boolean)this.revocationCache.isRevoked(RevocationCacheContexts.AUTHORIZATION_CODE, rootId));
    }

    @Test
    public void testSuccessSingleRefreshToken() throws IOException, NoSuchAlgorithmException, URISyntaxException, DataSealerException, ComponentInitializationException {
        String id = this.idGenerator.generateIdentifier();
        String rootId = this.idGenerator.generateIdentifier();
        this.setBasicAuth(this.clientIdSingle, this.clientSecret);
        this.storeMetadata(this.storageService, this.clientIdSingle, this.clientSecret, this.scope, new String[0]);
        this.setHttpFormRequest("POST", Collections.singletonMap("token", super.buildRefreshToken(this.clientIdSingle, "sub", Scope.parse((String)"openid"), null, id, rootId).toJSONObject().getAsString("refresh_token")));
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        this.parseSuccessResponse(result, OAuth2RevocationSuccessResponse.class);
        Assert.assertTrue((boolean)this.revocationCache.isRevoked(RevocationCacheContexts.SINGLE_ACCESS_OR_REFRESH_TOKENS, id));
        Assert.assertFalse((boolean)this.revocationCache.isRevoked(RevocationCacheContexts.AUTHORIZATION_CODE, rootId));
    }

    @Test
    public void testSuccessWithSamlMetadata() throws NoSuchAlgorithmException, URISyntaxException, DataSealerException, ComponentInitializationException {
        this.setBasicAuth(this.clientIdSaml, this.clientSecretSaml);
        this.setHttpFormRequest("POST", Collections.singletonMap("token", super.buildToken(this.clientIdSaml, "sub", Scope.parse((String)"openid")).toJSONObject().getAsString("access_token")));
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        this.parseSuccessResponse(result, OAuth2RevocationSuccessResponse.class);
    }

    @Test
    public void testSuccessWithLegacyToken() throws IOException, NoSuchAlgorithmException, URISyntaxException, DataSealerException, ComponentInitializationException, ParseException {
        this.setBasicAuth(this.clientId, this.clientSecret);
        this.storeMetadata(this.storageService, this.clientId, this.clientSecret, this.scope, new String[0]);
        this.setHttpFormRequest("POST", Collections.singletonMap("token", super.buildLegacyToken(this.clientId, "sub", Scope.parse((String)"openid"), new String[0]).toJSONObject().getAsString("access_token")));
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        this.parseSuccessResponse(result, OAuth2RevocationSuccessResponse.class);
    }

    @Test
    public void testSuccessWithLegacyConsentToken() throws IOException, NoSuchAlgorithmException, URISyntaxException, DataSealerException, ComponentInitializationException, ParseException {
        this.setBasicAuth(this.clientId, this.clientSecret);
        this.storeMetadata(this.storageService, this.clientId, this.clientSecret, this.scope, new String[0]);
        this.setHttpFormRequest("POST", Collections.singletonMap("token", super.buildLegacyToken(this.clientId, "sub", Scope.parse((String)"openid"), "mail").toJSONObject().getAsString("access_token")));
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        this.parseSuccessResponse(result, OAuth2RevocationSuccessResponse.class);
    }

    @Override
    protected FlowExecutionResult launchWithJwtAuthentication(SignedJWT jwt, JWSAlgorithm algorithm, ClientAuthenticationMethod method) throws Exception {
        if (ClientAuthenticationMethod.CLIENT_SECRET_JWT.equals((Object)method)) {
            this.storeMetadata(this.storageService, this.clientId, this.clientSecret, this.scope, algorithm, method, new String[0]);
        } else {
            this.storeMetadata(this.storageService, this.clientId, null, this.scope, algorithm, method, null, this.rsaPublicKey, new String[0]);
        }
        String accessToken = super.buildToken(this.clientId, "sub", Scope.parse((String)"openid")).toJSONObject().getAsString("access_token");
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put("token", accessToken);
        this.populateClientAssertionParams(requestParameters, jwt);
        this.setHttpFormRequest("POST", requestParameters);
        return this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
    }

    @Override
    protected Pair<String, String> getErrorDetaisForJWTValidation() {
        return new Pair((Object)"invalid_client", (Object)"Client authentication failed");
    }

    @Test
    public void testSuccessJWTNoAudience() throws JOSEException, IOException {
        this.setBasicAuth(this.clientId, this.clientSecret);
        this.storeMetadata(this.storageService, this.clientId, this.clientSecret, this.scope, new String[0]);
        this.setHttpFormRequest("POST", Map.of("token", this.buildJWTToken(this.clientId, "sub", this.scope, null, this.signingKey.getPrivateKey(), "RS256").toJSONObject().getAsString("access_token"), "token_type", "access_token"));
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        this.parseSuccessResponse(result, OAuth2RevocationSuccessResponse.class);
    }

    @Test
    public void testSuccessJWTAudience() throws JOSEException, IOException {
        this.setBasicAuth(this.clientId, this.clientSecret);
        this.storeMetadata(this.storageService, this.clientId, this.clientSecret, this.scope, new String[0]);
        this.setHttpFormRequest("POST", Map.of("token", this.buildJWTToken("https://sp2.example.org", "sub", this.scope, List.of("https://sp.example.org", this.clientId), this.signingKey.getPrivateKey(), "RS256").toJSONObject().getAsString("access_token"), "token_type", "access_token"));
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        this.parseSuccessResponse(result, OAuth2RevocationSuccessResponse.class);
    }

    @Test
    public void testSuccessJWTExpired() throws JOSEException, IOException {
        this.setBasicAuth(this.clientId, this.clientSecret);
        this.storeMetadata(this.storageService, this.clientId, this.clientSecret, this.scope, new String[0]);
        AccessTokenClaimsSet claims = (AccessTokenClaimsSet)new AccessTokenClaimsSet.Builder().setJWTID(this.idGenerator).setClientID(new ClientID(this.clientId)).setIssuer("https://op.example.org").setSubject(this.clientId).setIssuedAt(Instant.now().minusSeconds(300L)).setNotBefore(Instant.now().minusSeconds(300L)).setExpiresAt(Instant.now().minusSeconds(200L)).setAuthenticationTime(Instant.now()).setScope(this.scope).build();
        this.setHttpFormRequest("POST", Map.of("token", this.buildJWTToken(claims, this.signingKey.getPrivateKey(), "RS256").toJSONObject().getAsString("access_token"), "token_type", "access_token"));
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        this.parseSuccessResponse(result, OAuth2RevocationSuccessResponse.class);
    }

    @Test
    public void testSuccessJWTNotAuthorized() throws JOSEException, IOException {
        this.setBasicAuth(this.clientId, this.clientSecret);
        this.storeMetadata(this.storageService, this.clientId, this.clientSecret, this.scope, new String[0]);
        this.setHttpFormRequest("POST", Map.of("token", this.buildJWTToken("https://sp3.example.org", "sub", this.scope, List.of("https://sp.example.org", "https://sp2.example.org"), this.signingKey.getPrivateKey(), "RS256").toJSONObject().getAsString("access_token"), "token_type", "access_token"));
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        this.parseSuccessResponse(result, OAuth2RevocationSuccessResponse.class);
    }

    @Test
    public void testSuccessJWTWrongKey() throws JOSEException, IOException {
        this.setBasicAuth(this.clientId, this.clientSecret);
        this.storeMetadata(this.storageService, this.clientId, this.clientSecret, this.scope, new String[0]);
        this.setHttpFormRequest("POST", Map.of("token", this.buildJWTToken(this.clientId, "sub", this.scope, null, this.rsaPrivateKey, "RS256").toJSONObject().getAsString("access_token"), "token_type", "access_token"));
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        this.parseSuccessResponse(result, OAuth2RevocationSuccessResponse.class);
    }

    @Override
    protected void assertSuccessResponse(FlowExecutionResult result) {
        this.parseSuccessResponse(result, OAuth2RevocationSuccessResponse.class);
    }
}

