/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.flow;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.MACSigner;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.ErrorResponse;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.Response;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.PrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.time.Instant;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.idp.test.flows.AbstractFlowTest;
import net.shibboleth.utilities.java.support.net.HttpServletRequestResponseContext;
import net.shibboleth.utilities.java.support.security.DataSealer;
import org.apache.commons.codec.binary.Base64;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.storage.StorageService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.webflow.executor.FlowExecutionResult;
import org.springframework.webflow.test.MockExternalContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;

@ContextConfiguration(locations={"classpath*:/META-INF/net.shibboleth.idp/postconfig.xml"})
public abstract class AbstractOidcFlowTest
extends AbstractFlowTest {
    public static final String END_STATE_ID = "CommitResponse";
    private String flowId;
    private String endStateId;
    @Autowired
    @Qualifier(value="shibboleth.oidc.TokenSealer")
    private DataSealer dataSealer;

    protected AbstractOidcFlowTest(String id) {
        this(id, END_STATE_ID);
    }

    protected AbstractOidcFlowTest(String id, String endId) {
        this.flowId = id;
        this.endStateId = endId;
    }

    @BeforeMethod
    public void initializeMocks() {
        this.overrideEndStateOutput(this.flowId, this.endStateId);
        this.request = new MockHttpServletRequest();
        this.response = new MockHttpServletResponse();
        this.externalContext = new MockExternalContext();
        this.externalContext.setNativeRequest((Object)this.request);
        this.externalContext.setNativeResponse((Object)this.response);
    }

    @BeforeMethod
    public void initializeThreadLocals() {
        HttpServletRequestResponseContext.loadCurrent((HttpServletRequest)this.request, (HttpServletResponse)this.response);
    }

    protected DataSealer getDataSealer() {
        return this.dataSealer;
    }

    protected Response parseResponse(FlowExecutionResult result) {
        this.assertFlowExecutionOutcome(result.getOutcome(), END_STATE_ID);
        ProfileRequestContext prc = this.retrieveProfileRequestContext(result);
        Assert.assertNotNull((Object)prc);
        Assert.assertNotNull((Object)prc.getOutboundMessageContext());
        Object responseMessage = prc.getOutboundMessageContext().getMessage();
        Assert.assertNotNull((Object)responseMessage);
        Assert.assertTrue((boolean)(responseMessage instanceof Response));
        return (Response)responseMessage;
    }

    protected ErrorResponse parseErrorResponse(FlowExecutionResult result) {
        Response response = this.parseResponse(result);
        Assert.assertFalse((boolean)response.indicatesSuccess());
        Assert.assertTrue((boolean)(response instanceof ErrorResponse));
        return (ErrorResponse)response;
    }

    protected <AResponseType extends Response> AResponseType parseSuccessResponse(FlowExecutionResult result, Class<AResponseType> clazz) {
        Response response = this.parseResponse(result);
        Assert.assertTrue((boolean)response.indicatesSuccess());
        Assert.assertTrue((boolean)clazz.isInstance(response));
        return (AResponseType)((Response)clazz.cast(response));
    }

    protected void assertErrorCode(FlowExecutionResult result, String errorCode) {
        ErrorResponse errorResponse = this.parseErrorResponse(result);
        Assert.assertEquals((String)errorResponse.getErrorObject().getCode(), (String)errorCode);
    }

    protected void assertErrorDescriptionContains(FlowExecutionResult result, String errorDescription) {
        ErrorResponse errorResponse = this.parseErrorResponse(result);
        Assert.assertNotNull((Object)errorResponse.getErrorObject().getDescription());
        Assert.assertTrue((boolean)errorResponse.getErrorObject().getDescription().contains(errorDescription));
    }

    protected void setJsonRequest(String method, String body) {
        this.setRequest(method, body, "application/json");
    }

    protected void setHttpFormRequest(String method, Map<String, String> parameters) {
        this.setRequest(method, "", "application/x-www-form-urlencoded");
        this.request.setParameters(parameters);
    }

    protected void setBasicAuth(String username, String password) {
        this.request.removeHeader("Authorization");
        this.request.addHeader("Authorization", (Object)("Basic " + new String(Base64.encodeBase64((byte[])new String(username + ":" + password).getBytes()))));
    }

    protected void setRequest(String method, String body, String contentType) {
        this.request.setMethod(method);
        this.request.setContentType(contentType);
        this.request.setContent(body.getBytes());
    }

    protected void storeMetadata(StorageService storageService, String clientId, String secret, Scope scope, String ... redirectUri) throws IOException {
        this.storeMetadata(storageService, clientId, secret, scope, (JWSAlgorithm)null, ClientAuthenticationMethod.CLIENT_SECRET_BASIC, (JWSAlgorithm)null, (RSAPublicKey)null, redirectUri);
    }

    protected void storeMetadata(StorageService storageService, String clientId, String secret, Scope scope, JWSAlgorithm tokenEndpointSigAlg, ClientAuthenticationMethod tokenEndpointMethod, String ... redirectUri) throws IOException {
        this.storeMetadata(storageService, clientId, secret, scope, tokenEndpointSigAlg, tokenEndpointMethod, (JWSAlgorithm)null, (RSAPublicKey)null, redirectUri);
    }

    protected void storeMetadata(StorageService storageService, String clientId, String secret, Scope scope, JWSAlgorithm tokenEndpointSigAlg, ClientAuthenticationMethod tokenEndpointMethod, JWSAlgorithm userInfoSigAlg, String ... redirectUri) throws IOException {
        this.storeMetadata(storageService, clientId, secret, scope, tokenEndpointSigAlg, tokenEndpointMethod, userInfoSigAlg, (RSAPublicKey)null, redirectUri);
    }

    protected void storeMetadata(StorageService storageService, String clientId, String secret, Scope scope, JWSAlgorithm tokenEndpointSigAlg, ClientAuthenticationMethod tokenEndpointMethod, JWSAlgorithm userInfoSigAlg, RSAPublicKey publicKey, String ... redirectUri) throws IOException {
        this.storeMetadata(storageService, clientId, secret, scope, tokenEndpointSigAlg, null, null, tokenEndpointMethod, userInfoSigAlg, publicKey, redirectUri);
    }

    protected void storeMetadata(StorageService storageService, String clientId, String secret, Scope scope, JWSAlgorithm tokenEndpointSigAlg, JWEAlgorithm tokenEncAlg, EncryptionMethod encMethod, ClientAuthenticationMethod tokenEndpointMethod, JWSAlgorithm userInfoSigAlg, RSAPublicKey publicKey, String ... redirectUri) throws IOException {
        OIDCClientInformation information;
        OIDCClientMetadata metadata = new OIDCClientMetadata();
        metadata.setGrantTypes(new HashSet<GrantType>(List.of(GrantType.AUTHORIZATION_CODE, GrantType.REFRESH_TOKEN, GrantType.CLIENT_CREDENTIALS)));
        HashSet<URI> uris = new HashSet<URI>();
        if (redirectUri != null) {
            for (String uri : redirectUri) {
                try {
                    uris.add(new URI(uri));
                }
                catch (URISyntaxException e) {
                    throw new IOException(e);
                }
            }
        }
        HashSet<ResponseType> responseTypes = new HashSet<ResponseType>();
        responseTypes.add(new ResponseType(new String[]{"code"}));
        responseTypes.add(new ResponseType(new String[]{"id_token"}));
        responseTypes.add(new ResponseType(new String[]{"id_token", "token"}));
        responseTypes.add(new ResponseType(new String[]{"code", "id_token"}));
        responseTypes.add(new ResponseType(new String[]{"code", "token"}));
        responseTypes.add(new ResponseType(new String[]{"code", "id_token", "token"}));
        metadata.setResponseTypes(responseTypes);
        metadata.setRedirectionURIs(uris);
        metadata.setScope(scope);
        metadata.setTokenEndpointAuthJWSAlg(tokenEndpointSigAlg);
        metadata.setIDTokenJWEAlg(tokenEncAlg);
        metadata.setIDTokenJWEEnc(encMethod);
        metadata.setTokenEndpointAuthMethod(tokenEndpointMethod);
        metadata.setUserInfoJWSAlg(userInfoSigAlg);
        metadata.setCustomField("audience", List.of("https://rp.example.org", "https://rp2.example.org", "https://resource.example.org"));
        if (publicKey == null) {
            information = new OIDCClientInformation(new ClientID(clientId), new Date(), metadata, secret != null ? new Secret(secret) : null);
        } else {
            RSAKey rsaKey = new RSAKey.Builder(publicKey).build();
            JWKSet jwkSet = new JWKSet((JWK)rsaKey);
            metadata.setJWKSet(jwkSet);
            information = new OIDCClientInformation(new ClientID(clientId), new Date(), metadata, secret != null ? new Secret(secret) : null);
        }
        storageService.create("oidcClientInformation", clientId, information.toJSONObject().toJSONString(), Long.valueOf(System.currentTimeMillis() + 3600000L));
    }

    protected void removeMetadata(StorageService storageService, String clientId) throws IOException {
        storageService.delete("oidcClientInformation", clientId);
    }

    protected void storeConsent(StorageService storageService, String uid, String clientId, String ... ids) throws IOException {
        StringBuilder consented = new StringBuilder("[{\"id\":\"subject-public\"}");
        for (String id : ids) {
            consented.append(",{\"id\":\"" + id + "\"}");
        }
        storageService.create("intercept/attribute-release", uid + ":" + clientId, consented.append("]").toString(), Long.valueOf(System.currentTimeMillis() + 3600000L));
    }

    protected String buildJsonForLegacyToken(String subject, String clientId, Scope scope, String type, String ... consentedClaims) {
        Object consentClaims;
        if (consentedClaims != null && consentedClaims.length > 0) {
            String jsonArray = "[\"" + String.join((CharSequence)"\",\"", consentedClaims) + "\"]";
            consentClaims = "\"cnsntd_claims\":" + jsonArray + ",\"cnsntbl_claims\":" + jsonArray + ",";
        } else {
            consentClaims = "";
        }
        return "{\"sub\":\"" + subject + "\"," + (String)consentClaims + "\"iss\":\"https:\\/\\/op.example.org\",\"clid\":\"" + clientId + "\",\"prncpl\":\"jdoe\",\"type\":\"" + type + "\",\"nonce\":\"j2hzbXZhqkNh8to0\",\"dl_claims_ui\":{},\"auth_time\":" + Instant.now().getEpochSecond() + ",\"scope\":\"" + scope.toString() + "\",\"dl_claims\":{},\"redirect_uri\":\"https:\\/\\/example.org\\/cb\",\"exp\":" + Instant.now().plusSeconds(30L).getEpochSecond() + ",\"iat\":" + Instant.now().getEpochSecond() + ",\"jti\":\"" + this.idGenerator.generateIdentifier() + "\"}";
    }

    protected static SignedJWT createSecretJWT(JWTClaimsSet claimsSet, String clientSecret) throws JOSEException {
        SignedJWT jwt = new SignedJWT(new JWSHeader(JWSAlgorithm.HS256), claimsSet);
        MACSigner signer = new MACSigner(clientSecret);
        jwt.sign((JWSSigner)signer);
        return jwt;
    }

    protected static SignedJWT createPrivateKeyJWT(JWTClaimsSet claimsSet, RSAPrivateKey rsaPrivateKey) throws JOSEException {
        SignedJWT jwt = new SignedJWT(new JWSHeader(JWSAlgorithm.RS256), claimsSet);
        RSASSASigner signer = new RSASSASigner((PrivateKey)rsaPrivateKey);
        jwt.sign((JWSSigner)signer);
        return jwt;
    }
}

